/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.BlockSnapshot;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.events.IExcavateFilter;
import oreexcavation.groups.BlockEntry;
import oreexcavation.groups.BlockGroups;
import oreexcavation.handlers.EventHandler;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.overrides.ToolOverrideDefault;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.BlockPos;
import oreexcavation.utils.ToolEffectiveCheck;
import oreexcavation.utils.XPHelper;
import org.apache.logging.log4j.Level;

public class MiningAgent {
    private ItemStack blockStack = null;
    private Item origTool;
    public final List<BlockPos> minedBlocks = new ArrayList<BlockPos>();
    private final List<BlockPos> checkedBlocks = new ArrayList<BlockPos>();
    private final ArrayDeque<BlockPos> scheduled = new ArrayDeque();
    public final EntityPlayerMP player;
    public final BlockPos origin;
    public final UUID playerID;
    public EnumFacing facing = EnumFacing.SOUTH;
    public ExcavateShape shape = null;
    private final ExcavateHistory history;
    public final List<BlockEntry> blockGroup = new ArrayList<BlockEntry>();
    private final List<IExcavateFilter> filters = new ArrayList<IExcavateFilter>();
    public final Block block;
    public final int meta;
    public ToolOverride toolProps = ToolOverrideDefault.DEFAULT;
    private boolean subtypes = true;
    private boolean strictSubs = false;
    private List<BigItemStack> drops = new ArrayList<BigItemStack>();
    private int experience = 0;
    private static Method m_createStack = null;

    public MiningAgent(EntityPlayerMP player, BlockPos origin, Block block, int meta) {
        this.player = player;
        this.origin = origin;
        this.playerID = player.func_110124_au();
        this.block = block;
        this.meta = meta;
        this.history = new ExcavateHistory(player.field_70170_p.field_73011_w.field_76574_g);
        this.blockGroup.addAll(BlockGroups.INSTANCE.getGroup(block, meta));
        this.strictSubs = BlockGroups.INSTANCE.isStrict(block, meta);
        ItemStack held = player.func_70694_bm();
        Item item = this.origTool = held == null ? null : held.func_77973_b();
        if (held != null) {
            ToolOverride to = ToolOverrideHandler.INSTANCE.getOverride(held);
            this.toolProps = to != null ? to : this.toolProps;
        }
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void setOverride(ToolOverride override) {
        this.toolProps = override;
    }

    public void addFilter(IExcavateFilter filter) {
        this.filters.add(filter);
    }

    public void init() {
        if (m_createStack != null) {
            try {
                this.blockStack = (ItemStack)m_createStack.invoke((Object)this.block, this.meta);
                if (this.blockStack == null || this.blockStack.func_77973_b() == null) {
                    this.blockStack = null;
                }
            }
            catch (Exception e) {
                this.blockStack = null;
            }
        }
        this.subtypes = !this.strictSubs ? this.blockStack == null || !this.blockStack.func_77981_g() : false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    this.appendBlock(this.origin.offset(i, j, k));
                }
            }
        }
    }

    public MiningAgent setShape(ExcavateShape shape, EnumFacing facing) {
        this.shape = shape;
        this.facing = facing;
        return this;
    }

    public boolean tickMiner(Stopwatch timer) {
        if (this.origin == null || this.player == null || !this.player.func_70089_S() || this.minedBlocks.size() >= this.toolProps.getLimit()) {
            return true;
        }
        for (int n = 0; !(this.scheduled.isEmpty() || n >= this.toolProps.getSpeed() || this.minedBlocks.size() >= this.toolProps.getLimit() || ExcavationSettings.tpsGuard && timer.elapsed(TimeUnit.MILLISECONDS) > 40L); ++n) {
            int m;
            Item heldItem;
            ItemStack heldStack = this.player.func_70694_bm();
            Item item = heldItem = heldStack == null ? null : heldStack.func_77973_b();
            if (heldItem != this.origTool) {
                return true;
            }
            if (!this.hasEnergy(this.player)) {
                return true;
            }
            BlockPos pos = this.scheduled.poll();
            if (pos == null) continue;
            if (this.player.func_70011_f((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)this.toolProps.getRange()) {
                this.checkedBlocks.add(pos);
                continue;
            }
            Block b = this.player.field_70170_p.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
            if (EventHandler.isBlockBlacklisted(b, m = this.player.field_70170_p.func_72805_g(pos.getX(), pos.getY(), pos.getZ())) || !b.func_149678_a(m, false)) {
                this.checkedBlocks.add(pos);
                continue;
            }
            boolean flag = b == this.block && (this.subtypes || m == this.meta);
            boolean bl = flag = flag || BlockGroups.INSTANCE.quickCheck(this.blockGroup, b, m);
            if (!flag && this.blockStack != null && !this.strictSubs) {
                ItemStack stack;
                try {
                    stack = (ItemStack)m_createStack.invoke((Object)b, m);
                }
                catch (Exception e) {
                    stack = null;
                }
                if (stack != null && stack.func_77973_b() == this.blockStack.func_77973_b() && stack.func_77960_j() == this.blockStack.func_77960_j()) {
                    flag = true;
                }
            }
            if (!flag) continue;
            if (ExcavationSettings.maxUndos > 0) {
                this.player.field_70170_p.captureBlockSnapshots = true;
                this.player.field_70170_p.capturedBlockSnapshots.clear();
            }
            if (!ExcavationSettings.ignoreTools && !ToolEffectiveCheck.canHarvestBlock(this.player.field_70170_p, b, m, pos, (EntityPlayer)this.player)) {
                this.checkedBlocks.add(pos);
                continue;
            }
            if (this.player.field_71134_c.func_73084_b(pos.getX(), pos.getY(), pos.getZ()) || this.player.field_70170_p.func_147439_a(pos.getX(), pos.getY(), pos.getZ()) == Blocks.field_150350_a) {
                if (ExcavationSettings.maxUndos > 0) {
                    this.player.field_70170_p.captureBlockSnapshots = false;
                    EventHandler.captureAgent = null;
                    while (this.player.field_70170_p.capturedBlockSnapshots.size() > 0) {
                        BlockSnapshot snap = (BlockSnapshot)this.player.field_70170_p.capturedBlockSnapshots.get(0);
                        if (pos.equals(new BlockPos(snap.x, snap.y, snap.z))) {
                            this.history.addRecordedBlock(new BlockHistory(snap));
                        }
                        this.player.field_70170_p.capturedBlockSnapshots.remove(0);
                        this.player.field_70170_p.markAndNotifyBlock(snap.x, snap.y, snap.z, this.player.field_70170_p.func_72964_e(snap.x >> 4, snap.y >> 4), snap.getReplacedBlock(), snap.getCurrentBlock(), snap.flag);
                    }
                    EventHandler.captureAgent = this;
                }
                if (!this.player.field_71075_bZ.field_75098_d) {
                    this.player.func_71024_bL().func_75113_a(this.toolProps.getExaustion());
                    if (this.toolProps.getExperience() > 0) {
                        XPHelper.addXP((EntityPlayer)this.player, -this.toolProps.getExperience(), false);
                    }
                }
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.appendBlock(pos.offset(i, j, k));
                        }
                    }
                }
                this.minedBlocks.add(pos);
            } else {
                OreExcavation.logger.warn("Block harvest failed unexpectedly.\nBlock: " + b + ":" + m + "\nTool: " + heldStack + "\nPos: " + pos.toString());
            }
            this.player.field_70170_p.capturedBlockSnapshots.clear();
            this.player.field_70170_p.captureBlockSnapshots = false;
            this.checkedBlocks.add(pos);
        }
        if (!this.player.field_71075_bZ.field_75098_d) {
            XPHelper.syncXP(this.player);
        }
        return this.scheduled.size() <= 0 || this.minedBlocks.size() >= this.toolProps.getLimit();
    }

    public void appendBlock(BlockPos pos) {
        if (pos == null || this.checkedBlocks.contains(pos) || this.scheduled.contains(pos)) {
            return;
        }
        if (this.player.func_70011_f((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)this.toolProps.getRange() || !this.player.func_82247_a(pos.getX(), pos.getY(), pos.getZ(), this.facing.ordinal(), this.player.func_70694_bm())) {
            return;
        }
        if (this.shape != null && !this.shape.isValid(this.origin, pos, this.facing)) {
            return;
        }
        for (IExcavateFilter filter : this.filters) {
            if (filter.canHarvest(this.player, this, pos)) continue;
            return;
        }
        this.scheduled.add(pos);
    }

    private boolean hasEnergy(EntityPlayerMP player) {
        return !(!(this.toolProps.getExaustion() <= 0.0f) && player.func_71024_bL().func_75116_a() <= 0 || this.toolProps.getExperience() > 0 && XPHelper.getPlayerXP((EntityPlayer)player) < (long)this.toolProps.getExperience());
    }

    public void dropEverything() {
        MiningAgent ca = EventHandler.captureAgent;
        EventHandler.captureAgent = null;
        this.history.setRecievedStacks(this.drops);
        this.history.setRecievedXP(this.experience);
        for (BigItemStack bigStack : this.drops) {
            for (ItemStack stack : bigStack.getCombinedStacks()) {
                EntityItem eItem;
                if (!ExcavationSettings.autoPickup) {
                    eItem = new EntityItem(this.player.field_70170_p, (double)this.origin.getX() + 0.5, (double)this.origin.getY() + 0.5, (double)this.origin.getZ() + 0.5, stack);
                    this.player.field_70170_p.func_72838_d((Entity)eItem);
                    continue;
                }
                eItem = new EntityItem(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, stack);
                this.player.field_70170_p.func_72838_d((Entity)eItem);
            }
        }
        if (this.experience > 0) {
            EntityXPOrb orb = null;
            orb = ExcavationSettings.autoPickup ? new EntityXPOrb(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.experience) : new EntityXPOrb(this.player.field_70170_p, (double)this.origin.getX() + 0.5, (double)this.origin.getY() + 0.5, (double)this.origin.getZ() + 0.5, this.experience);
            this.player.field_70170_p.func_72838_d((Entity)orb);
        }
        this.drops.clear();
        this.experience = 0;
        EventHandler.captureAgent = ca;
    }

    public void addItemDrop(ItemStack stack) {
        for (BigItemStack bigStack : this.drops) {
            if (!bigStack.equals(stack)) continue;
            bigStack.stackSize += stack.field_77994_a;
            return;
        }
        this.drops.add(new BigItemStack(stack));
    }

    public void addExperience(int value) {
        this.experience += value;
    }

    public boolean hasMinedPosition(BlockPos pos) {
        return this.checkedBlocks.contains(pos);
    }

    public ExcavateHistory getHistory() {
        return this.history;
    }

    static {
        try {
            m_createStack = Block.class.getDeclaredMethod("func_149644_j", Integer.TYPE);
            m_createStack.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                m_createStack = Block.class.getDeclaredMethod("createStackedBlock", Integer.TYPE);
                m_createStack.setAccessible(true);
            }
            catch (Exception e2) {
                OreExcavation.logger.log(Level.INFO, "Unable to use block hooks for excavation", (Throwable)e2);
            }
        }
    }
}

