/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.events.EventExcavate;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.undo.RestoreResult;
import oreexcavation.utils.BlockPos;

public class MiningScheduler {
    public static final MiningScheduler INSTANCE = new MiningScheduler();
    private ArrayDeque<MiningAgent> agents = new ArrayDeque();
    private HashMap<String, ExcavateHistory> undoing = new HashMap();
    private HashMap<UUID, List<ExcavateHistory>> undoHistory = new HashMap();
    private Stopwatch timer = Stopwatch.createStarted();

    private MiningScheduler() {
    }

    public MiningAgent getActiveAgent(UUID uuid) {
        for (MiningAgent a : this.agents) {
            if (!a.getPlayerID().equals(uuid)) continue;
            return a;
        }
        return null;
    }

    public void stopMining(EntityPlayerMP player) {
        MiningAgent a = this.getActiveAgent(player.func_110124_au());
        if (a != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Post(a));
            a.dropEverything();
            this.agents.remove(a);
        }
    }

    @Deprecated
    public MiningAgent startMining(EntityPlayerMP player, BlockPos pos, Block block, int meta, ExcavateShape shape) {
        return this.startMining(player, pos, block, meta, shape, ExcavateShape.getFacing((EntityPlayer)player));
    }

    public MiningAgent startMining(EntityPlayerMP player, BlockPos pos, Block block, int meta) {
        return this.startMining(player, pos, block, meta, null, EnumFacing.NORTH);
    }

    public MiningAgent startMining(EntityPlayerMP player, BlockPos pos, Block block, int meta, ExcavateShape shape, EnumFacing dir) {
        MiningAgent existing = this.getActiveAgent(player.func_110124_au());
        if (existing != null) {
            existing.appendBlock(pos);
        } else {
            existing = new MiningAgent(player, pos, block, meta);
            if (shape != null) {
                existing.setShape(shape, dir);
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pre(existing))) {
                return null;
            }
            this.agents.add(existing);
            existing.init();
        }
        return existing;
    }

    public RestoreResult attemptUndo(EntityPlayer player) {
        ArrayList list = this.undoHistory.get(player.func_110124_au());
        ArrayList arrayList = list = list != null ? list : new ArrayList();
        if (list.size() <= 0) {
            return RestoreResult.NO_UNDO_HISTORY;
        }
        RestoreResult result = ((ExcavateHistory)list.get(list.size() - 1)).canRestore(MinecraftServer.func_71276_C(), player);
        if (result == RestoreResult.SUCCESS) {
            this.undoing.put(player.func_70005_c_(), (ExcavateHistory)list.remove(list.size() - 1));
        }
        return result;
    }

    public void appendHistory(UUID uuid, ExcavateHistory history) {
        ArrayList<ExcavateHistory> list = this.undoHistory.get(uuid);
        list = list != null ? list : new ArrayList<ExcavateHistory>();
        list.add(history);
        while (list.size() > ExcavationSettings.maxUndos) {
            list.remove(0);
        }
        this.undoHistory.put(uuid, list);
    }

    public void tickAgents(MinecraftServer server) {
        boolean complete;
        this.timer.reset();
        this.timer.start();
        int n = this.agents.size();
        for (int i = 0; i < n && !this.agents.isEmpty(); ++i) {
            if (ExcavationSettings.tpsGuard && this.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = true;
                break;
            }
            MiningAgent a = this.agents.poll();
            if (a == null) continue;
            EventHandler.captureAgent = a;
            complete = a.tickMiner(this.timer);
            EventHandler.captureAgent = null;
            if (complete) {
                MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Post(a));
                a.dropEverything();
                this.appendHistory(a.getPlayerID(), a.getHistory());
                continue;
            }
            this.agents.add(a);
        }
        Iterator<Map.Entry<String, ExcavateHistory>> iterUndo = this.undoing.entrySet().iterator();
        while (iterUndo.hasNext()) {
            if (ExcavationSettings.tpsGuard && this.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = true;
                break;
            }
            Map.Entry<String, ExcavateHistory> entry = iterUndo.next();
            complete = entry.getValue().tickRestore(server, (EntityPlayer)server.func_71203_ab().func_152612_a(entry.getKey()));
            if (!complete) continue;
            iterUndo.remove();
        }
        this.timer.stop();
    }

    public void resetAll() {
        this.agents.clear();
        this.undoing.clear();
        this.undoHistory.clear();
    }
}

