/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.overrides;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.utils.JsonHelper;

public final class ToolOverrideHandler {
    public static ToolOverrideHandler INSTANCE = new ToolOverrideHandler();
    private List<ToolOverride> list = new ArrayList<ToolOverride>();

    private ToolOverrideHandler() {
    }

    public void loadOverrides(JsonObject json) {
        this.list.clear();
        for (JsonElement je : JsonHelper.GetArray(json, "overrides")) {
            JsonObject jo;
            ToolOverride to;
            if (je == null || !je.isJsonObject() || (to = ToolOverride.readFromString(JsonHelper.GetString(jo = je.getAsJsonObject(), "itemID", ""))) == null) continue;
            to.setSpeed(JsonHelper.GetNumber(jo, "speed", ExcavationSettings.mineSpeed).intValue());
            to.setLimit(JsonHelper.GetNumber(jo, "limit", ExcavationSettings.mineLimit).intValue());
            to.setRange(JsonHelper.GetNumber(jo, "range", ExcavationSettings.mineRange).intValue());
            to.setExaustion(JsonHelper.GetNumber(jo, "exaustion", Float.valueOf(ExcavationSettings.exaustion)).floatValue());
            to.setExperience(JsonHelper.GetNumber(jo, "experience", ExcavationSettings.experience).intValue());
            this.list.add(to);
        }
    }

    public ToolOverride getOverride(ItemStack stack) {
        for (ToolOverride o : this.list) {
            if (!o.isApplicable(stack)) continue;
            return o;
        }
        return null;
    }

    public JsonObject getDefaultOverrides() {
        JsonObject json = new JsonObject();
        JsonArray jAry = new JsonArray();
        JsonObject jo = new JsonObject();
        jo.addProperty("itemID", "examplemod:nerfed_pickaxe:0");
        jo.addProperty("speed", (Number)1);
        jo.addProperty("limit", (Number)0);
        jo.addProperty("range", (Number)0);
        jo.addProperty("exaustion", (Number)Float.valueOf(0.1f));
        jo.addProperty("experience", (Number)0);
        jAry.add((JsonElement)jo);
        json.add("overrides", (JsonElement)jAry);
        return json;
    }
}

