/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.shapes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.BlockPos;
import oreexcavation.utils.JsonHelper;
import org.apache.logging.log4j.Level;

public class ExcavateShape {
    private String name = "New Shape";
    private int shape = 0;
    private int maxDepth = -1;
    private byte reticle = (byte)12;

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setReticle(int x, int y) {
        this.reticle = (byte)MathHelper.func_76125_a((int)(y * 5 + x), (int)0, (int)24);
    }

    public int getReticle() {
        return this.reticle;
    }

    public void setMaxDepth(int value) {
        this.maxDepth = value;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getShapeMask() {
        return this.shape;
    }

    public void setMask(int mask) {
        this.shape = mask;
    }

    public void setMask(int x, int y, boolean allow) {
        if (x < 0 || x >= 5 || y < 0 || y >= 5) {
            return;
        }
        int mask = ExcavateShape.posToMask(x, y);
        this.shape = allow ? (this.shape |= mask) : (this.shape &= ~mask);
    }

    public void readFromJson(JsonObject json) {
        this.name = JsonHelper.GetString(json, "name", "New Shape");
        this.maxDepth = JsonHelper.GetNumber(json, "depth", -1).intValue();
        this.reticle = (byte)MathHelper.func_76125_a((int)JsonHelper.GetNumber(json, "reticle", 12).byteValue(), (int)0, (int)24);
        JsonArray jmsk = JsonHelper.GetArray(json, "mask");
        this.shape = 0;
        int y = 4;
        for (JsonElement je : jmsk) {
            if (y < 0) break;
            if (je == null || !je.isJsonPrimitive()) continue;
            String row = je.getAsString();
            for (int x = 0; x < 5 && x < row.length(); ++x) {
                this.setMask(x, y, row.toUpperCase().charAt(x) == 'X');
            }
            --y;
        }
    }

    public JsonObject writeToJson(JsonObject json) {
        json.addProperty("name", this.name);
        json.addProperty("depth", (Number)Math.max(-1, this.maxDepth));
        json.addProperty("reticle", (Number)this.reticle);
        JsonArray jmsk = new JsonArray();
        for (int y = 4; y >= 0; --y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < 5; ++x) {
                int mask = ExcavateShape.posToMask(x, y);
                boolean valid = (this.shape & mask) == mask;
                sb.append(valid ? "X" : "O");
            }
            jmsk.add((JsonElement)new JsonPrimitive(sb.toString()));
        }
        json.add("mask", (JsonElement)jmsk);
        return json;
    }

    public boolean isValid(BlockPos origin, BlockPos offset, EnumFacing facing) {
        int x = offset.getX() - origin.getX();
        int y = offset.getY() - origin.getY();
        int z = offset.getZ() - origin.getZ();
        BlockPos rotOff = this.counterRotate(new BlockPos(x, y, z), facing);
        if ((rotOff = rotOff.offset(this.reticle % 5, this.reticle / 5, 0)).getX() < 0 || rotOff.getX() >= 5 || rotOff.getY() < 0 || rotOff.getY() >= 5 || rotOff.getZ() < 0 || this.maxDepth >= 0 && rotOff.getZ() >= this.maxDepth) {
            return false;
        }
        int mask = ExcavateShape.posToMask(rotOff.getX(), rotOff.getY());
        return (this.shape & mask) == mask;
    }

    private BlockPos counterRotate(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.rotate(pos, EnumFacing.DOWN);
            }
            case EAST: {
                return this.rotate(pos, EnumFacing.WEST);
            }
            case NORTH: {
                return this.rotate(pos, EnumFacing.NORTH);
            }
            case SOUTH: {
                return pos;
            }
            case UP: {
                return this.rotate(pos, EnumFacing.UP);
            }
            case WEST: {
                return this.rotate(pos, EnumFacing.EAST);
            }
        }
        return pos;
    }

    private BlockPos rotate(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new BlockPos(pos.getX(), pos.getZ() * -1, pos.getY() * -1);
            }
            case EAST: {
                return new BlockPos(pos.getZ() * -1, pos.getY(), pos.getX());
            }
            case NORTH: {
                return new BlockPos(pos.getX() * -1, pos.getY(), pos.getZ() * -1);
            }
            case SOUTH: {
                return pos;
            }
            case UP: {
                return new BlockPos(pos.getX(), pos.getZ(), pos.getY());
            }
            case WEST: {
                return new BlockPos(pos.getZ(), pos.getY(), pos.getX() * -1);
            }
        }
        return pos;
    }

    public static int posToMask(int x, int y) {
        int idx = y * 5 + x;
        return (int)Math.pow(2.0, idx);
    }

    public static EnumFacing getFacing(EntityPlayer player, Block block, int meta, BlockPos pos) {
        MovingObjectPosition mop;
        try {
            double d = player.func_70011_f((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            block.func_149719_a((IBlockAccess)player.field_70170_p, pos.getX(), pos.getY(), pos.getZ());
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)block.func_149704_x(), (double)block.func_149665_z(), (double)block.func_149706_B(), (double)block.func_149753_y(), (double)block.func_149669_A(), (double)block.func_149693_C());
            aabb.func_72317_d((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            Vec3 v = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.eyeHeight), (double)player.field_70161_v);
            Vec3 vl = player.func_70040_Z();
            vl = Vec3.func_72443_a((double)(vl.field_72450_a * (d + 1.0)), (double)(vl.field_72448_b * (d + 1.0)), (double)(vl.field_72449_c * (d + 1.0)));
            Vec3 v2 = v.func_72441_c(vl.field_72450_a, vl.field_72448_b, vl.field_72449_c);
            mop = aabb.func_72327_a(v, v2);
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.INFO, "Unable to excavation direction for player " + player.getDisplayName(), (Throwable)e);
            mop = null;
        }
        if (mop != null) {
            int s = mop.field_72310_e - mop.field_72310_e % 2;
            return EnumFacing.values()[s += (mop.field_72310_e + 1) % 2];
        }
        return ExcavateShape.getFacing(player);
    }

    public static EnumFacing getFacing(EntityPlayer player) {
        Vec3 dir = player.func_70040_Z();
        dir = dir.func_72432_b();
        double ax = Math.abs(dir.field_72450_a);
        double ay = Math.abs(dir.field_72448_b);
        double az = Math.abs(dir.field_72449_c);
        if (ax > ay && ax > az) {
            if (dir.field_72450_a > 0.0) {
                return EnumFacing.EAST;
            }
            return EnumFacing.WEST;
        }
        if (az > ay && az > ax) {
            if (dir.field_72449_c > 0.0) {
                return EnumFacing.SOUTH;
            }
            return EnumFacing.NORTH;
        }
        if (ay > ax && ay > az) {
            if (dir.field_72448_b > 0.0) {
                return EnumFacing.UP;
            }
            return EnumFacing.DOWN;
        }
        return EnumFacing.SOUTH;
    }
}

