/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S1FPacketSetExperience;

public class XPHelper {
    private static long[] QUICK_XP = new long[2147];

    public static void addXP(EntityPlayer player, long xp) {
        XPHelper.addXP(player, xp, true);
    }

    public static void addXP(EntityPlayer player, long xp, boolean sync) {
        long experience = XPHelper.getPlayerXP(player) + xp;
        player.field_71067_cb = experience >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)experience;
        player.field_71068_ca = XPHelper.getXPLevel(experience);
        long expForLevel = XPHelper.getLevelXP(player.field_71068_ca);
        player.field_71106_cc = (float)((double)(experience - expForLevel) / (double)XPHelper.xpBarCap(player));
        if (sync && player instanceof EntityPlayerMP) {
            XPHelper.syncXP((EntityPlayerMP)player);
        }
    }

    public static void syncXP(EntityPlayerMP player) {
        player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
    }

    public static long getPlayerXP(EntityPlayer player) {
        return XPHelper.getLevelXP(player.field_71068_ca) + Math.round((double)XPHelper.xpBarCap(player) * (double)player.field_71106_cc);
    }

    public static long xpBarCap(EntityPlayer player) {
        if (player.field_71068_ca < 16) {
            return 17L;
        }
        if (player.field_71068_ca < 31) {
            return (long)(3.0 * (double)((long)player.field_71068_ca - 15L) + 17.0);
        }
        return (long)(7.0 * (double)((long)player.field_71068_ca - 30L) + 62.0);
    }

    public static int getXPLevel(long xp) {
        int i;
        if (xp <= 0L) {
            return 0;
        }
        for (i = 0; i < QUICK_XP.length && QUICK_XP[i] <= xp; ++i) {
        }
        if (i > 0) {
            i = (i - 1) * 1000000;
        }
        while (i < Integer.MAX_VALUE && XPHelper.getLevelXP(i) <= xp) {
            ++i;
        }
        return i - 1;
    }

    public static long getLevelXP(int level) {
        if (level <= 0) {
            return 0L;
        }
        if (level < 16) {
            return (long)((double)level * 17.0);
        }
        if (level > 15 && level < 31) {
            return (long)(1.5 * Math.pow(level, 2.0) - (double)level * 29.5 + 360.0);
        }
        return (long)(3.5 * Math.pow(level, 2.0) - (double)level * 151.5 + 2220.0);
    }

    static {
        for (int i = 0; i < QUICK_XP.length; ++i) {
            XPHelper.QUICK_XP[i] = XPHelper.getLevelXP(i * 1000000);
        }
    }
}

