/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.api;

import java.util.ArrayList;
import java.util.List;
import lain.mods.peacefulsurface.api.interfaces.IEntityObj;
import lain.mods.peacefulsurface.api.interfaces.IEntitySpawnFilter;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;

public class PeaceAPI {
    private static final List<IEntitySpawnFilter> filters = new ArrayList<IEntitySpawnFilter>();
    private static final List<Runnable> listeners = new ArrayList<Runnable>();

    public static boolean addFilter(IEntitySpawnFilter filter) {
        return filters.add(filter);
    }

    public static void clearFilters() {
        filters.clear();
    }

    public static void clearReloadListeners() {
        listeners.clear();
    }

    public static int countFilters() {
        return filters.size();
    }

    public static boolean filterEntity(IEntityObj entity, IWorldObj world, double x, double y, double z) {
        return filters.stream().filter(IEntitySpawnFilter::enabled).anyMatch(filter -> filter.filterEntity(entity, world, x, y, z));
    }

    public static void notifyReloadListeners() {
        listeners.forEach(Runnable::run);
    }

    public static boolean registerReloadListener(Runnable listener) {
        return listeners.add(listener);
    }

    public static boolean removeFilter(IEntitySpawnFilter filter) {
        return filters.remove(filter);
    }

    public static boolean unregisterReloadListener(Runnable listener) {
        return listeners.remove(listener);
    }
}

