/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lain.mods.peacefulsurface.api.interfaces.IEntityObj;
import lain.mods.peacefulsurface.api.interfaces.IEntitySpawnFilter;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;

public class JsonRule
implements IEntitySpawnFilter {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean Disabled;
    public boolean Living;
    public boolean Monster;
    public boolean Animal;
    public boolean Checking_LightLevel;
    public boolean Raining;
    public boolean Thundering;
    public boolean Day;
    public boolean Night;
    public boolean InvertedMobFilter;
    public boolean InvertedDimensionFilter;
    public boolean InvertedLightLevelChecking;
    public String mobFilter = "";
    public String dimensionFilter = "";
    public int LightLevel;
    public int MoonPhase;
    public boolean DisabledUnderBloodmoon;
    private transient boolean valid = false;
    private transient Pattern _mobFilter;
    private transient Pattern _dimensionFilter;

    public static Collection<JsonRule> fromDirectory(File dir) throws IOException {
        return JsonRule.fromDirectory(dir, ignored -> true);
    }

    public static Collection<JsonRule> fromDirectory(File dir, Predicate<? super IOException> handler) throws IOException {
        ArrayList<JsonRule> list = new ArrayList<JsonRule>();
        String newLine = System.getProperty("line.separator");
        for (File file2 : dir.listFiles(file -> file.getName().toLowerCase().endsWith(".json"))) {
            try {
                list.add(JsonRule.fromJson(Files.lines(file2.toPath(), StandardCharsets.UTF_8).collect(Collectors.joining(newLine))));
            }
            catch (IOException e) {
                if (handler.test(e)) continue;
                throw e;
            }
        }
        return list;
    }

    public static JsonRule fromJson(String json) {
        return (JsonRule)gson.fromJson(json, JsonRule.class);
    }

    @Override
    public boolean enabled() {
        return !this.Disabled;
    }

    @Override
    public boolean filterEntity(IEntityObj entity, IWorldObj world, double x, double y, double z) {
        String dimensionName;
        this.validate();
        if (this.DisabledUnderBloodmoon && world.isBloodMoon()) {
            return false;
        }
        if (this.MoonPhase != 0 && world.getMoonPhase() != this.MoonPhase - 1) {
            return false;
        }
        if (this.Living && !entity.isLiving()) {
            return false;
        }
        if (this.Monster && !entity.isMonster()) {
            return false;
        }
        if (this.Animal && !entity.isAnimal()) {
            return false;
        }
        String mobName = entity.getEntityName();
        if (mobName == null) {
            return false;
        }
        if (this.InvertedMobFilter ? !this._mobFilter.matcher(mobName).lookingAt() : this._mobFilter.matcher(mobName).lookingAt()) {
            return false;
        }
        if (this.InvertedDimensionFilter) {
            dimensionName = world.getWorldName();
            String dimensionName2 = String.format("DIM%d", world.getWorldID());
            if (!this._dimensionFilter.matcher(dimensionName).lookingAt() && !this._dimensionFilter.matcher(dimensionName2).lookingAt()) {
                return false;
            }
        } else {
            dimensionName = world.getWorldName();
            String dimensionName2 = String.format("DIM%d", world.getWorldID());
            if (this._dimensionFilter.matcher(dimensionName).lookingAt() || this._dimensionFilter.matcher(dimensionName2).lookingAt()) {
                return false;
            }
        }
        if (this.Checking_LightLevel) {
            int n = world.getLightLevel(x, y, z);
            if (this.InvertedLightLevelChecking ? n <= this.LightLevel : n > this.LightLevel) {
                return true;
            }
        }
        if (this.Raining && !world.isRaining()) {
            return true;
        }
        if (this.Thundering && !world.isThundering()) {
            return true;
        }
        if (this.Day && !world.isDayTime()) {
            return true;
        }
        return this.Night && world.isDayTime();
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        if (this.MoonPhase < 0 || this.MoonPhase > 8) {
            this.MoonPhase = 0;
        }
        this._mobFilter = Pattern.compile(this.mobFilter);
        this._dimensionFilter = Pattern.compile(this.dimensionFilter);
        this.valid = true;
    }
}

