/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl.forge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lain.mods.peacefulsurface.api.interfaces.IEntityObj;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimal;

public class ForgeEntityObj
implements IEntityObj {
    private static final ForgeEntityObj dummy = new ForgeEntityObj(){
        {
            this.name = "[Dummy]";
            this.animal = false;
            this.living = false;
            this.monster = false;
        }
    };
    private static final LoadingCache<EntityType<? extends Entity>, ForgeEntityObj> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<EntityType<? extends Entity>, ForgeEntityObj>(){

        public ForgeEntityObj load(EntityType<? extends Entity> key) throws Exception {
            try {
                ForgeEntityObj obj = new ForgeEntityObj();
                obj.name = EntityType.func_200718_a(key).toString();
                obj.animal = IAnimal.class.isAssignableFrom(key.func_201760_c());
                obj.living = EntityLivingBase.class.isAssignableFrom(key.func_201760_c());
                obj.monster = IMob.class.isAssignableFrom(key.func_201760_c());
                return obj;
            }
            catch (Throwable t) {
                return dummy;
            }
        }
    });
    String name;
    boolean animal;
    boolean living;
    boolean monster;

    public static ForgeEntityObj get(Entity entity) {
        if (entity == null) {
            return dummy;
        }
        return (ForgeEntityObj)cache.getUnchecked((Object)entity.func_200600_R());
    }

    private ForgeEntityObj() {
    }

    @Override
    public String getEntityName() {
        return this.name;
    }

    @Override
    public boolean isAnimal() {
        return this.animal;
    }

    @Override
    public boolean isLiving() {
        return this.living;
    }

    @Override
    public boolean isMonster() {
        return this.monster;
    }
}

