/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.init.forge;

import com.google.common.io.Resources;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import lain.mods.peacefulsurface.api.PeaceAPI;
import lain.mods.peacefulsurface.impl.JsonRule;
import lain.mods.peacefulsurface.impl.forge.ForgeEntityObj;
import lain.mods.peacefulsurface.impl.forge.ForgeWorldObj;
import lain.mods.peacefulsurface.init.forge.ForgePeacefulSurface;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

enum Proxy {
    INSTANCE;

    Logger logger = LogManager.getLogger(ForgePeacefulSurface.class);

    void handleCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.isSpawner() || !PeaceAPI.filterEntity(ForgeEntityObj.get(event.getEntity()), ForgeWorldObj.get(event.getWorld()), event.getX(), event.getY(), event.getZ())) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    void handleServerStartingEvent(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        event.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reloadpeace").requires(source -> source.func_197034_c(3))).executes(context -> {
            Futures.addCallback((ListenableFuture)server.func_152344_a(this::reloadRules), (FutureCallback)new FutureCallback<Object>(){

                public void onFailure(Throwable t) {
                }

                public void onSuccess(Object result) {
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentTranslation("commands.reloadpeace.done", new Object[0]), true);
                }
            }, (Executor)MoreExecutors.directExecutor());
            return 0;
        }));
    }

    void init() {
        this.reloadRules();
        MinecraftForge.EVENT_BUS.addListener(this::handleCheckSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::handleServerStartingEvent);
    }

    void reloadRules() {
        try {
            this.logger.info("[PeacefulSurface] Loading filters...");
            PeaceAPI.clearFilters();
            File dir = Paths.get(".", "config", "PeacefulSurface_Rules").toFile();
            if (!dir.exists() && dir.mkdirs()) {
                try {
                    this.logger.info("[PeacefulSurface] Writing DefaultRule...");
                    FileUtils.copyURLToFile((URL)Resources.getResource((String)"/DefaultRule.json"), (File)new File(dir, "DefaultRule.json"));
                    this.logger.info("[PeacefulSurface] Successfully wrote DefaultRule.");
                }
                catch (IOException e) {
                    this.logger.error("[PeacefulSurface] Failed to write DefaultRule.", (Throwable)e);
                }
            }
            JsonRule.fromDirectory(dir).forEach(PeaceAPI::addFilter);
            PeaceAPI.notifyReloadListeners();
            this.logger.info("[PeacefulSurface] Loaded {} filter{}.", (Object)PeaceAPI.countFilters(), (Object)(PeaceAPI.countFilters() == 1 ? "" : "s"));
        }
        catch (Throwable t) {
            this.logger.error("[PeacefulSurface] Failed to load filters.", t);
            PeaceAPI.clearFilters();
        }
    }
}

