/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl.forge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;

public class ForgeWorldObj
implements IWorldObj {
    private static final ForgeWorldObj dummy = new ForgeWorldObj(){
        {
            this.w = new WeakReference<Object>(null);
            this.id = 999;
            this.name = "[Dummy]";
        }
    };
    private static final LoadingCache<IWorld, ForgeWorldObj> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<IWorld, ForgeWorldObj>(){

        public ForgeWorldObj load(IWorld key) throws Exception {
            try {
                ForgeWorldObj obj = new ForgeWorldObj();
                obj.w = new WeakReference<IWorld>(key);
                obj.id = key.func_201675_m().func_186058_p().func_186068_a();
                obj.name = DimensionType.func_212678_a((DimensionType)key.func_201675_m().func_186058_p()).toString();
                return obj;
            }
            catch (Throwable t) {
                return dummy;
            }
        }
    });
    WeakReference<IWorld> w;
    int id;
    String name;

    public static ForgeWorldObj get(IWorld world) {
        if (world == null) {
            return dummy;
        }
        return (ForgeWorldObj)cache.getUnchecked((Object)world);
    }

    private ForgeWorldObj() {
    }

    @Override
    public int getLightLevel(double x, double y, double z) {
        IWorld o = (IWorld)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.func_201672_e().func_72911_I() ? o.func_205049_d(new BlockPos(x, y, z), 10) : o.func_201696_r(new BlockPos(x, y, z));
    }

    @Override
    public int getMoonPhase() {
        IWorld o = (IWorld)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.func_201675_m().func_76559_b(o.func_201672_e().func_72820_D());
    }

    @Override
    public int getWorldID() {
        return this.id;
    }

    @Override
    public String getWorldName() {
        return this.name;
    }

    @Override
    public boolean isBloodMoon() {
        return false;
    }

    @Override
    public boolean isDayTime() {
        IWorld o = (IWorld)this.w.get();
        if (o == null) {
            return false;
        }
        return o.func_201672_e().func_72935_r();
    }

    @Override
    public boolean isRaining() {
        IWorld o = (IWorld)this.w.get();
        if (o == null) {
            return false;
        }
        return o.func_201672_e().func_72896_J();
    }

    @Override
    public boolean isThundering() {
        IWorld o = (IWorld)this.w.get();
        if (o == null) {
            return false;
        }
        return o.func_201672_e().func_72911_I();
    }
}

