/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.init.fabric;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Map;
import java.util.WeakHashMap;
import lain.mods.peacefulsurface.api.PeaceAPI;
import lain.mods.peacefulsurface.impl.JsonRule;
import lain.mods.peacefulsurface.impl.fabric.FabricEntityObj;
import lain.mods.peacefulsurface.impl.fabric.FabricWorldObj;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.server.ServerStartCallback;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_4538;
import org.apache.commons.io.FileUtils;

public class FabricPeacefulSurface
implements ModInitializer {
    private static final Map<class_1299<?>, FabricEntityObj> entities = new WeakHashMap();
    private static final Map<class_4538, FabricWorldObj> worlds = new WeakHashMap<class_4538, FabricWorldObj>();

    public static FabricEntityObj wrapEntity(class_1299<?> entity) {
        if (!entities.containsKey(entity)) {
            entities.put(entity, new FabricEntityObj(entity));
        }
        return entities.get(entity);
    }

    public static FabricWorldObj wrapWorld(class_4538 world) {
        if (!worlds.containsKey(world)) {
            worlds.put(world, new FabricWorldObj(world));
        }
        return worlds.get(world);
    }

    public void onInitialize() {
        ServerStartCallback.EVENT.register(server -> server.method_3734().method_9235().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadpeace").requires(source -> source.method_9259(3))).executes(context -> {
            server.execute(() -> {
                this.reloadConfig();
                ((class_2168)context.getSource()).method_9226(new class_2588("commands.reloadpeace.done", new Object[0]).method_10862(new class_2583().method_10977(class_124.field_1054)), true);
            });
            return 0;
        })));
        this.reloadConfig();
    }

    public void reloadConfig() {
        try {
            System.out.println("[PeacefulSurface] Loading filters...");
            PeaceAPI.clearFilters();
            File dir = Paths.get(".", "config", "PeacefulSurface_Rules").toFile();
            if (!dir.exists() && dir.mkdirs()) {
                try {
                    System.out.println("[PeacefulSurface] Writing DefaultRule...");
                    FileUtils.copyInputStreamToFile((InputStream)FabricPeacefulSurface.class.getResourceAsStream("/DefaultRule.json"), (File)new File(dir, "DefaultRule.json"));
                    System.out.println("[PeacefulSurface] Successfully wrote DefaultRule.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("[PeacefulSurface] Failed to write DefaultRule.");
                }
            }
            JsonRule.fromDirectory(dir).forEach(PeaceAPI::addFilter);
            PeaceAPI.notifyReloadListeners();
            System.out.println(String.format("[PeacefulSurface] Loaded %d filter%s.", PeaceAPI.countFilters(), PeaceAPI.countFilters() == 1 ? "" : "s"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("[PeacefulSurface] Failed to load filters.");
            PeaceAPI.clearFilters();
        }
    }
}

