/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface.impl.forge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import lain.mods.peacefulsurface.api.interfaces.IWorldObj;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class ForgeWorldObj
implements IWorldObj {
    private static final ForgeWorldObj dummy = new ForgeWorldObj(){
        {
            this.w = new WeakReference<Object>(null);
            this.name = "[Dummy]";
        }
    };
    private static final LoadingCache<ServerWorld, ForgeWorldObj> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ServerWorld, ForgeWorldObj>(){

        public ForgeWorldObj load(ServerWorld key) throws Exception {
            try {
                ForgeWorldObj obj = new ForgeWorldObj();
                obj.w = new WeakReference<ServerWorld>(key);
                obj.name = key.func_234923_W_().func_240901_a_().toString();
                return obj;
            }
            catch (Throwable t) {
                return dummy;
            }
        }
    });
    WeakReference<ServerWorld> w;
    String name;

    public static ForgeWorldObj get(ServerWorld world) {
        if (world == null) {
            return dummy;
        }
        return (ForgeWorldObj)cache.getUnchecked((Object)world);
    }

    private ForgeWorldObj() {
    }

    @Override
    public int getLightLevel(double x, double y, double z) {
        ServerWorld o = (ServerWorld)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.func_72911_I() ? o.func_205049_d(new BlockPos(x, y, z), 10) : o.func_201696_r(new BlockPos(x, y, z));
    }

    @Override
    public int getMoonPhase() {
        ServerWorld o = (ServerWorld)this.w.get();
        if (o == null) {
            return 0;
        }
        return o.func_230315_m_().func_236035_c_(o.func_241851_ab());
    }

    @Override
    public String getWorldName() {
        return this.name;
    }

    @Override
    public boolean isBloodMoon() {
        return false;
    }

    @Override
    public boolean isDayTime() {
        ServerWorld o = (ServerWorld)this.w.get();
        if (o == null) {
            return false;
        }
        return o.func_72935_r();
    }

    @Override
    public boolean isRaining() {
        ServerWorld o = (ServerWorld)this.w.get();
        if (o == null) {
            return false;
        }
        return o.func_72896_J();
    }

    @Override
    public boolean isThundering() {
        ServerWorld o = (ServerWorld)this.w.get();
        if (o == null) {
            return false;
        }
        return o.func_72911_I();
    }
}

