/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface;

import java.io.File;
import java.util.regex.Pattern;
import lain.mods.peacefulsurface.IEntitySpawnFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class LegacyConfigRule
implements IEntitySpawnFilter {
    public static final int DISABLED = 0;
    public static final int LIVING = 1;
    public static final int MOB = 2;
    public static final int CHECKING_LIGHTLEVEL = 4;
    public static final int RAINING = 8;
    public static final int THUNDERING = 16;
    public static final int DAY = 32;
    public static final int NIGHT = 64;
    int filteringRules = 6;
    String mobFilter = "(\\bSlime\\b)";
    String dimensionFilter = "(\\bThe End\\b)|(\\bNether\\b)";
    int LIGHTLEVEL = 0;
    Pattern _mobFilter;
    Pattern _dimensionFilter;

    public LegacyConfigRule(File config) {
        Configuration cfg = new Configuration(config);
        this.filteringRules = cfg.get("general", "filteringRules", this.filteringRules).getInt();
        this.mobFilter = cfg.get("general", "mobFilter", this.mobFilter).getString();
        this.dimensionFilter = cfg.get("general", "dimensionFilter", this.dimensionFilter).getString();
        this.LIGHTLEVEL = cfg.get("general", "LIGHTLEVEL", this.LIGHTLEVEL).getInt();
        this._mobFilter = Pattern.compile(this.mobFilter);
        this._dimensionFilter = Pattern.compile(this.dimensionFilter);
    }

    @Override
    public boolean enabled() {
        return this.filteringRules != 0;
    }

    @Override
    public boolean filterEntity(Entity entity, World world, float x, float y, float z) {
        int f = this.filteringRules;
        if ((f & 1) != 0 && !(entity instanceof EntityLivingBase)) {
            return false;
        }
        if ((f & 2) != 0 && !(entity instanceof IMob)) {
            return false;
        }
        String mobName = EntityList.func_75621_b((Entity)entity);
        if (mobName == null || this._mobFilter.matcher(mobName).lookingAt()) {
            return false;
        }
        String dimensionName = world.field_73011_w.func_80007_l();
        if (dimensionName != null && this._dimensionFilter.matcher(dimensionName).lookingAt()) {
            return false;
        }
        dimensionName = String.format("DIM%d", world.field_73011_w.field_76574_g);
        if (this._dimensionFilter.matcher(dimensionName).lookingAt()) {
            return false;
        }
        if ((f & 4) != 0 && world.func_72972_b(EnumSkyBlock.Sky, MathHelper.func_76141_d((float)x), MathHelper.func_76141_d((float)y), MathHelper.func_76141_d((float)z)) > this.LIGHTLEVEL) {
            return true;
        }
        if ((f & 8) != 0 && !world.func_72896_J()) {
            return true;
        }
        if ((f & 0x10) != 0 && !world.func_72911_I()) {
            return true;
        }
        if ((f & 0x20) != 0 && !world.func_72935_r()) {
            return true;
        }
        return (f & 0x40) != 0 && world.func_72935_r();
    }
}

