/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.peacefulsurface;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import lain.mods.peacefulsurface.CommandReloadPeace;
import lain.mods.peacefulsurface.IEntitySpawnFilter;
import lain.mods.peacefulsurface.JsonRule;
import lain.mods.peacefulsurface.LegacyConfigRule;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="PeacefulSurface", useMetadata=true)
public class PeacefulSurface {
    Logger logger;
    File configFile;
    File dirRules;
    final List<IEntitySpawnFilter> filters = Lists.newArrayList();
    @Mod.Instance(value="PeacefulSurface")
    public static PeacefulSurface instance;

    public static void setDisabled() {
        MinecraftForge.EVENT_BUS.unregister((Object)instance);
    }

    public static void setEnabled() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void CheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        for (IEntitySpawnFilter filter : this.filters) {
            if (!filter.enabled() || !filter.filterEntity(event.entity, event.world, event.x, event.y, event.z)) continue;
            event.setResult(Event.Result.DENY);
            break;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PeacefulSurface.setEnabled();
    }

    @Mod.EventHandler
    public void loadConfig(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.configFile = event.getSuggestedConfigurationFile();
        this.dirRules = new File(event.getModConfigurationDirectory(), "PeacefulSurface_Rules");
        if (!this.dirRules.exists()) {
            this.dirRules.mkdirs();
            if (!this.configFile.exists()) {
                try {
                    this.logger.info("Writing DefaultRule.json...");
                    FileUtils.copyInputStreamToFile((InputStream)PeacefulSurface.class.getResourceAsStream("/DefaultRule.json"), (File)new File(this.dirRules, "DefaultRule.json"));
                    this.logger.info("DefaultRule.json is successfully written.");
                }
                catch (IOException e) {
                    this.logger.catching(Level.ERROR, (Throwable)e);
                }
            }
        }
        this.reloadConfig();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandReloadPeace());
    }

    protected void reloadConfig() {
        try {
            this.logger.info("Loading filters...");
            this.filters.clear();
            for (File f : this.dirRules.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".json");
                }
            })) {
                this.filters.add((IEntitySpawnFilter)JsonRule.gson.fromJson((Reader)Files.newBufferedReader(f.toPath()), JsonRule.class));
            }
            if (this.configFile.exists()) {
                this.filters.add(new LegacyConfigRule(this.configFile));
            }
            this.logger.info(String.format("Loaded %d filter%s.", this.filters.size(), this.filters.size() > 1 ? "s" : ""));
        }
        catch (Exception e) {
            this.logger.catching(Level.ERROR, (Throwable)e);
        }
    }
}

