/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_465;

public interface AutoTransferHandler {
    default public double getPriority() {
        return 0.0;
    }

    public Result handle(Context var1);

    public static final class ContextImpl
    implements Context {
        boolean actuallyCrafting;
        class_465<?> containerScreen;
        Supplier<RecipeDisplay> recipeDisplaySupplier;

        private ContextImpl(boolean actuallyCrafting, class_465<?> containerScreen, Supplier<RecipeDisplay> recipeDisplaySupplier) {
            this.actuallyCrafting = actuallyCrafting;
            this.containerScreen = containerScreen;
            this.recipeDisplaySupplier = recipeDisplaySupplier;
        }

        @Override
        public boolean isActuallyCrafting() {
            return this.actuallyCrafting;
        }

        @Override
        public class_465<?> getContainerScreen() {
            return this.containerScreen;
        }

        @Override
        public RecipeDisplay getRecipe() {
            return this.recipeDisplaySupplier.get();
        }
    }

    public static final class ResultImpl
    implements Result {
        private boolean successful;
        private boolean applicable;
        private String errorKey;
        private IntList integers = new IntArrayList();
        private int color;

        private ResultImpl() {
            this.successful = true;
            this.applicable = true;
        }

        public ResultImpl(boolean applicable) {
            this.successful = false;
            this.applicable = applicable;
        }

        public ResultImpl(String errorKey, IntList integers, int color) {
            this.successful = false;
            this.applicable = true;
            this.errorKey = errorKey;
            if (integers != null) {
                this.integers = integers;
            }
            this.color = color;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public boolean isApplicable() {
            return this.applicable;
        }

        @Override
        public String getErrorKey() {
            return this.errorKey;
        }

        @Override
        public IntList getIntegers() {
            return this.integers;
        }
    }

    public static interface Context {
        public static Context create(boolean actuallyCrafting, class_465<?> containerScreen, RecipeDisplay recipeDisplay) {
            return new ContextImpl(actuallyCrafting, containerScreen, () -> recipeDisplay);
        }

        default public class_310 getMinecraft() {
            return class_310.method_1551();
        }

        public boolean isActuallyCrafting();

        public class_465<?> getContainerScreen();

        public RecipeDisplay getRecipe();

        default public class_1703 getContainer() {
            return this.getContainerScreen().method_17577();
        }

        default public ContainerScreenOverlay getOverlay() {
            return ScreenHelper.getLastOverlay();
        }
    }

    public static interface Result {
        public static Result createSuccessful() {
            return new ResultImpl();
        }

        public static Result createNotApplicable() {
            return new ResultImpl(false);
        }

        public static Result createFailed(String errorKey) {
            return new ResultImpl(errorKey, (IntList)new IntArrayList(), 1744764928);
        }

        public static Result createFailedCustomButtonColor(String errorKey, int color) {
            return new ResultImpl(errorKey, (IntList)new IntArrayList(), color);
        }

        public static Result createFailed(String errorKey, IntList redSlots) {
            return new ResultImpl(errorKey, redSlots, 1744764928);
        }

        public static Result createFailedCustomButtonColor(String errorKey, IntList redSlots, int color) {
            return new ResultImpl(errorKey, redSlots, color);
        }

        public int getColor();

        public boolean isSuccessful();

        public boolean isApplicable();

        public String getErrorKey();

        public IntList getIntegers();
    }
}

