/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.renderers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.renderers.RecipeRenderer;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3611;

public class SimpleRecipeRenderer
extends RecipeRenderer {
    private static final Comparator<EntryStack> ENTRY_COMPARATOR = (o1, o2) -> {
        if (o1.getType() == EntryStack.Type.FLUID) {
            if (o2.getType() == EntryStack.Type.ITEM) {
                return -1;
            }
            return o1.getFluid().hashCode() - o2.getFluid().hashCode();
        }
        if (o2.getType() == EntryStack.Type.FLUID) {
            if (o1.getType() == EntryStack.Type.ITEM) {
                return 1;
            }
            return o1.getFluid().hashCode() - o2.getFluid().hashCode();
        }
        class_1799 i1 = o1.getItemStack();
        class_1799 i2 = o2.getItemStack();
        if (i1.method_7909() == i2.method_7909()) {
            if (i1.method_7947() != i2.method_7947()) {
                return i1.method_7947() - i2.method_7947();
            }
            int compare = Boolean.compare(i1.method_7985(), i2.method_7985());
            if (compare != 0) {
                return compare;
            }
            if (i1.method_7969().method_10546() != i2.method_7969().method_10546()) {
                return i1.method_7969().method_10546() - i2.method_7969().method_10546();
            }
            return i1.method_7969().hashCode() - i2.method_7969().hashCode();
        }
        return i1.method_7909().hashCode() - i2.method_7909().hashCode();
    };
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<Renderer> inputRenderer;
    private Renderer outputRenderer;
    private QueuedTooltip lastTooltip;

    @Deprecated
    public SimpleRecipeRenderer(Supplier<List<List<class_1799>>> input, Supplier<List<class_1799>> output) {
        this(() -> ((List)input.get()).stream().map(s -> s.stream().map(EntryStack::create).collect(Collectors.toList())).collect(Collectors.toList()), () -> ((List)output.get()).stream().map(EntryStack::create).collect(Collectors.toList()), 0);
    }

    public SimpleRecipeRenderer(Supplier<List<List<EntryStack>>> input, Supplier<List<EntryStack>> output, int forDifferentConstructor) {
        ArrayList newList = Lists.newArrayList();
        List a = input.get().stream().map(stacks -> new class_3545(stacks, (Object)stacks.stream().map(EntryStack::getAmount).max(Integer::compareTo).orElse(1))).collect(Collectors.toList());
        for (class_3545 pair : a) {
            Optional<class_3545> any = newList.stream().filter(pairr -> SimpleRecipeRenderer.equalsList((List)pair.method_15442(), (List)pairr.method_15442())).findAny();
            if (any.isPresent()) {
                ((AtomicInteger)any.get().method_15441()).addAndGet((Integer)pair.method_15441());
                continue;
            }
            newList.add(new class_3545(pair.method_15442(), (Object)new AtomicInteger((Integer)pair.method_15441())));
        }
        ArrayList b = Lists.newArrayList();
        for (class_3545 pair : newList) {
            b.add(((List)pair.method_15442()).stream().map(stack -> {
                EntryStack s = stack.copy();
                s.setAmount(((AtomicInteger)pair.method_15441()).get());
                return s;
            }).collect(Collectors.toList()));
        }
        this.inputRenderer = b.stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> SimpleRecipeRenderer.fromEntries(stacks)).collect(Collectors.toList());
        this.outputRenderer = SimpleRecipeRenderer.fromEntries(output.get().stream().filter(stack -> !stack.isEmpty()).collect(Collectors.toList()));
    }

    @Deprecated
    private static Renderer fromEntries(List<EntryStack> entries) {
        List list;
        boolean isItem = true;
        for (EntryStack entryStack : entries) {
            if (entryStack.getType() == EntryStack.Type.ITEM) continue;
            isItem = false;
        }
        if (isItem) {
            return Renderer.fromItemStacks(entries.stream().map(EntryStack::getItemStack).collect(Collectors.toList()));
        }
        boolean isFluid = true;
        for (EntryStack entry : entries) {
            if (entry.getType() == EntryStack.Type.FLUID) continue;
            isFluid = false;
        }
        if (isFluid && !(list = entries.stream().map(EntryStack::getFluid).collect(Collectors.toList())).isEmpty()) {
            return Renderer.fromFluid((class_3611)list.get(0));
        }
        return Renderer.empty();
    }

    public static boolean equalsList(List<EntryStack> list_1, List<EntryStack> list_2) {
        List stacks_2;
        List stacks_1 = list_1.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2 = list_2.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList()))) {
            return true;
        }
        if (stacks_1.size() != stacks_2.size()) {
            return false;
        }
        for (int i = 0; i < stacks_1.size(); ++i) {
            if (((EntryStack)stacks_1.get(i)).equalsIgnoreTagsAndAmount((EntryStack)stacks_2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        this.lastTooltip = null;
        int xx = x + 4;
        int yy = y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (Renderer itemStackRenderer : this.inputRenderer) {
            itemStackRenderer.setBlitOffset(this.getBlitOffset() + 50);
            if (this.lastTooltip == null && class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen && mouseX >= (double)xx && mouseX <= (double)(xx + 16) && mouseY >= (double)yy && mouseY <= (double)(yy + 16)) {
                this.lastTooltip = itemStackRenderer.getQueuedTooltip(delta);
            }
            itemStackRenderer.render(xx + 8, yy + 6, mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = x + 5;
            j = 0;
        }
        xx = x + 5 + 18 * (this.getItemsPerLine() - 2);
        yy = y + this.getHeight() / 2 - 8;
        class_308.method_1450();
        class_310.method_1551().method_1531().method_4618(CHEST_GUI_TEXTURE);
        this.blit(xx, yy, 0, 28, 18, 18);
        this.outputRenderer.setBlitOffset(this.getBlitOffset() + 50);
        this.outputRenderer.render((xx += 18) + 8, yy + 6, mouseX, mouseY, delta);
        if (this.lastTooltip == null && class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen && mouseX >= (double)xx && mouseX <= (double)(xx + 16) && mouseY >= (double)yy && mouseY <= (double)(yy + 16)) {
            this.lastTooltip = this.outputRenderer.getQueuedTooltip(delta);
        }
    }

    @Override
    @Nullable
    public QueuedTooltip getQueuedTooltip(float delta) {
        return this.lastTooltip;
    }

    @Override
    public int getHeight() {
        return 4 + this.getItemsHeight() * 18;
    }

    public int getItemsHeight() {
        return class_3532.method_15386((float)((float)this.inputRenderer.size() / (float)(this.getItemsPerLine() - 2)));
    }

    public int getItemsPerLine() {
        return class_3532.method_15375((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }
}

