/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.util.Optional;
import me.shedaniel.math.api.Point;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_124;

public abstract class ClickableLabelWidget
extends LabelWidget {
    public boolean focused;
    public boolean clickable;

    public ClickableLabelWidget(int x, int y, String text, boolean clickable) {
        super(x, y, text);
        this.clickable = clickable;
    }

    public ClickableLabelWidget(int x, int y, String text) {
        this(x, y, text, true);
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        int color = this.getDefaultColor();
        if (this.clickable && this.isHovered(mouseX, mouseY)) {
            color = this.getHoveredColor();
        }
        int width = this.font.method_1727(this.text);
        if (this.isHasShadows()) {
            this.font.method_1720((this.isHovered(mouseX, mouseY) ? class_124.field_1073.toString() : "") + this.text, (float)(this.x - width / 2), (float)this.y, color);
        } else {
            this.font.method_1729((this.isHovered(mouseX, mouseY) ? class_124.field_1073.toString() : "") + this.text, (float)(this.x - width / 2), (float)this.y, color);
        }
        if (this.clickable && this.getTooltips().isPresent()) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
            } else if (this.focused) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(new Point(this.x, this.y), this.getTooltips().get().split("\n")));
            }
        }
    }

    public int getHoveredColor() {
        return ScreenHelper.isDarkModeEnabled() ? -1 : -10027060;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickable && this.containsMouse(mouseX, mouseY)) {
            this.onLabelClicked();
            return true;
        }
        return false;
    }

    public Optional<String> getTooltips() {
        return Optional.empty();
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.clickable || !this.focused) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        this.onLabelClicked();
        return true;
    }

    public boolean changeFocus(boolean boolean_1) {
        if (!this.clickable) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.clickable && (this.containsMouse(mouseX, mouseY) || this.focused);
    }

    public abstract void onLabelClicked();
}

