/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.compat.RenderHelper;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.annotations.Experimental;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_364;

@Experimental
public class EntryWidget
extends WidgetWithBounds {
    protected static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected static final class_2960 RECIPE_GUI_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    private Rectangle bounds;
    private List<EntryStack> entryStacks;

    protected EntryWidget(int x, int y) {
        this.bounds = new Rectangle(x - 1, y - 1, 18, 18);
        this.entryStacks = new ArrayList<EntryStack>();
    }

    public static EntryWidget create(int x, int y) {
        return new EntryWidget(x, y);
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    public EntryWidget interactable(boolean b) {
        this.interactable = b;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    public EntryWidget clearStacks() {
        this.entryStacks.clear();
        return this;
    }

    public EntryWidget entry(EntryStack stack) {
        this.entryStacks.add(stack);
        return this;
    }

    public EntryWidget entries(Collection<EntryStack> stacks) {
        this.entryStacks.addAll(stacks);
        return this;
    }

    protected EntryStack getCurrentEntry() {
        if (this.entryStacks.isEmpty()) {
            return EntryStack.empty();
        }
        if (this.entryStacks.size() == 1) {
            return this.entryStacks.get(0);
        }
        return this.entryStacks.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.entryStacks.size() / 1.0)));
    }

    public List<EntryStack> entries() {
        return this.entryStacks;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    protected Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (this.background) {
            this.drawBackground(mouseX, mouseY, delta);
        }
        this.drawCurrentEntry(mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.tooltips && highlighted) {
            this.queueTooltip(mouseX, mouseY, delta);
        }
        if (this.highlight && highlighted) {
            this.drawHighlighted(mouseX, mouseY, delta);
        }
    }

    protected void drawBackground(int mouseX, int mouseY, float delta) {
        this.minecraft.method_1531().method_4618(ScreenHelper.isDarkModeEnabled() ? RECIPE_GUI_DARK : RECIPE_GUI);
        this.blit(this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
    }

    protected void drawCurrentEntry(int mouseX, int mouseY, float delta) {
        EntryStack entry = this.getCurrentEntry();
        entry.setZ(200);
        entry.render(this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(int mouseX, int mouseY, float delta) {
        EntryStack entry = this.getCurrentEntry();
        QueuedTooltip tooltip = entry.getTooltip(mouseX, mouseY);
        if (tooltip != null) {
            ScreenHelper.getLastOverlay().addTooltip(tooltip);
        }
    }

    protected void drawHighlighted(int mouseX, int mouseY, float delta) {
        RenderHelper.disableLighting();
        RenderHelper.disableDepthTest();
        RenderHelper.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = ScreenHelper.isDarkModeEnabled() ? -1877929711 : -2130706433;
        this.blitOffset = 300;
        Rectangle bounds = this.getInnerBounds();
        this.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
        this.blitOffset = 0;
        RenderHelper.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderHelper.enableLighting();
        RenderHelper.enableDepthTest();
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentEntry());
            }
            if (button == 1) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentEntry());
            }
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(PointHelper.fromMouse())) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentEntry());
            }
            if (ClientHelper.getInstance().getUsageKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentEntry());
            }
        }
        return false;
    }
}

