/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.impl.BaseBoundsHandlerImpl;
import me.shedaniel.rei.impl.DisplayHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_465;

public class RecipeHelperImpl
implements RecipeHelper {
    private static final Comparator<DisplayVisibilityHandler> VISIBILITY_HANDLER_COMPARATOR;
    private static final Comparator<class_1860> RECIPE_COMPARATOR;
    private final List<AutoTransferHandler> autoTransferHandlers = Lists.newArrayList();
    private final List<RecipeFunction> recipeFunctions = Lists.newArrayList();
    private final List<RecipeHelper.ScreenClickArea> screenClickAreas = Lists.newArrayList();
    private final AtomicInteger recipeCount = new AtomicInteger();
    private final Map<class_2960, List<RecipeDisplay>> recipeCategoryListMap = Maps.newHashMap();
    private final List<RecipeCategory> categories = Lists.newArrayList();
    private final Map<class_2960, ButtonAreaSupplier> speedCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<class_2960, List<List<class_1799>>> categoryWorkingStations = Maps.newHashMap();
    private final List<DisplayVisibilityHandler> displayVisibilityHandlers = Lists.newArrayList();
    private final List<LiveRecipeGenerator<?>> liveRecipeGenerators = Lists.newArrayList();
    private class_1863 recipeManager;

    @Override
    public List<EntryStack> findCraftableEntriesByItems(List<class_1799> inventoryItems) {
        ArrayList<EntryStack> craftables = new ArrayList<EntryStack>();
        for (List<RecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (RecipeDisplay recipeDisplay : value) {
                int slotsCraftable = 0;
                List<List<EntryStack>> requiredInput = recipeDisplay.getRequiredEntries();
                block2: for (List<EntryStack> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    boolean slotDone = false;
                    for (class_1799 possibleType : inventoryItems) {
                        EntryStack possibleEntryStack = EntryStack.create(possibleType);
                        for (EntryStack slotPossible : slot) {
                            if (!possibleEntryStack.equals(slotPossible)) continue;
                            ++slotsCraftable;
                            slotDone = true;
                            break;
                        }
                        if (!slotDone) continue;
                        continue block2;
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredEntries().size()) continue;
                craftables.addAll(recipeDisplay.getOutputEntries());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void registerCategory(RecipeCategory category) {
        this.categories.add(category);
        this.recipeCategoryListMap.put(category.getIdentifier(), Lists.newLinkedList());
        this.categoryWorkingStations.put(category.getIdentifier(), Lists.newLinkedList());
    }

    @Override
    public void registerWorkingStations(class_2960 category, List<class_1799> ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations));
    }

    @Override
    public void registerWorkingStations(class_2960 category, class_1799 ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations).stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    @Override
    public List<List<class_1799>> getWorkingStations(class_2960 category) {
        return this.categoryWorkingStations.get(category);
    }

    @Override
    public void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(display);
    }

    private void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display, int index) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(index, display);
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getRecipesFor(EntryStack stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<class_2960, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            for (RecipeDisplay recipeDisplay : entry.getValue()) {
                for (EntryStack outputStack : recipeDisplay.getOutputEntries()) {
                    if (!stack.equals(outputStack)) continue;
                    ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getRecipeFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
            if (stack.getType() != EntryStack.Type.ITEM) continue;
            liveRecipeGenerator.getRecipeFor(stack.getItemStack()).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    @Override
    public RecipeCategory getCategory(class_2960 identifier) {
        return this.categories.stream().filter(category -> category.getIdentifier().equals((Object)identifier)).findFirst().orElse(null);
    }

    @Override
    public class_1863 getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getUsagesFor(EntryStack stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<class_2960, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            block1: for (RecipeDisplay recipeDisplay : entry.getValue()) {
                boolean found = false;
                for (List<EntryStack> input : recipeDisplay.getInputEntries()) {
                    for (EntryStack otherEntry : input) {
                        if (!otherEntry.equals(stack)) continue;
                        ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getUsageFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
            if (stack.getType() != EntryStack.Type.ITEM) continue;
            liveRecipeGenerator.getUsageFor(stack.getItemStack()).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    @Override
    public List<RecipeCategory> getAllCategories() {
        return new LinkedList<RecipeCategory>(this.categories);
    }

    @Override
    public Optional<ButtonAreaSupplier> getAutoCraftButtonArea(RecipeCategory category) {
        if (!this.speedCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return Optional.ofNullable(bounds -> new Rectangle(bounds.getMaxX() - 16, bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.speedCraftAreaSupplierMap.get(category.getIdentifier()));
    }

    @Override
    public void registerAutoCraftButtonArea(class_2960 category, ButtonAreaSupplier rectangle) {
        if (rectangle == null) {
            if (this.speedCraftAreaSupplierMap.containsKey(category)) {
                this.speedCraftAreaSupplierMap.remove(category);
            }
        } else {
            this.speedCraftAreaSupplierMap.put(category, rectangle);
        }
    }

    @Override
    public void registerDefaultSpeedCraftButtonArea(class_2960 category) {
        this.registerAutoCraftButtonArea(category, bounds -> new Rectangle(bounds.getMaxX() - 16, bounds.getMaxY() - 16, 10, 10));
    }

    public void recipesLoaded(class_1863 recipeManager) {
        ScreenHelper.clearData();
        this.recipeCount.set(0);
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.speedCraftAreaSupplierMap.clear();
        this.screenClickAreas.clear();
        this.categoryWorkingStations.clear();
        this.recipeFunctions.clear();
        this.displayVisibilityHandlers.clear();
        this.liveRecipeGenerators.clear();
        this.autoTransferHandlers.clear();
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetData();
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        BaseBoundsHandlerImpl baseBoundsHandler = new BaseBoundsHandlerImpl();
        RoughlyEnoughItemsCore.getDisplayHelper().registerBoundsHandler(baseBoundsHandler);
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).setBaseBoundsHandler(baseBoundsHandler);
        long startTime = System.currentTimeMillis();
        LinkedList<REIPluginEntry> plugins = new LinkedList<REIPluginEntry>(RoughlyEnoughItemsCore.getPlugins());
        plugins.sort((first, second) -> second.getPriority() - first.getPriority());
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Loading %d plugins: %s", (Object)plugins.size(), (Object)plugins.stream().map(REIPluginEntry::getPluginIdentifier).map(class_2960::toString).collect(Collectors.joining(", ")));
        Collections.reverse(plugins);
        RoughlyEnoughItemsCore.getEntryRegistry().getModifiableEntryList().clear();
        Version reiVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("roughlyenoughitems").get()).getMetadata().getVersion();
        if (!(reiVersion instanceof SemanticVersion)) {
            RoughlyEnoughItemsCore.LOGGER.warn("[REI] Roughly Enough Items is not using semantic versioning, will be ignoring plugins' minimum versions!");
        }
        for (REIPluginEntry plugin : plugins) {
            try {
                if (reiVersion instanceof SemanticVersion && plugin.getMinimumVersion().compareTo((SemanticVersion)reiVersion) > 0) {
                    throw new IllegalStateException("Requires " + plugin.getMinimumVersion().getFriendlyString() + " version of REI!");
                }
                if (!(plugin instanceof REIPluginV0)) continue;
                ((REIPluginV0)plugin).preRegister();
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] " + plugin.getPluginIdentifier().toString() + " plugin failed to pre register!", e);
            }
        }
        for (REIPluginEntry plugin : plugins) {
            class_2960 identifier = plugin.getPluginIdentifier();
            try {
                if (reiVersion instanceof SemanticVersion && plugin.getMinimumVersion().compareTo((SemanticVersion)reiVersion) > 0) {
                    return;
                }
                if (plugin instanceof REIPluginV0) {
                    ((REIPluginV0)plugin).registerBounds(RoughlyEnoughItemsCore.getDisplayHelper());
                    ((REIPluginV0)plugin).registerEntries(RoughlyEnoughItemsCore.getEntryRegistry());
                    ((REIPluginV0)plugin).registerPluginCategories(this);
                    ((REIPluginV0)plugin).registerRecipeDisplays(this);
                    ((REIPluginV0)plugin).registerOthers(this);
                    continue;
                }
                throw new IllegalStateException("Invaild Plugin Class!");
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] " + identifier.toString() + " plugin failed to load!", e);
            }
        }
        for (REIPluginEntry plugin : plugins) {
            try {
                if (reiVersion instanceof SemanticVersion && plugin.getMinimumVersion().compareTo((SemanticVersion)reiVersion) > 0) {
                    return;
                }
                if (!(plugin instanceof REIPluginV0)) continue;
                ((REIPluginV0)plugin).postRegister();
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] " + plugin.getPluginIdentifier().toString() + " plugin failed to post register!", e);
            }
        }
        if (!this.recipeFunctions.isEmpty()) {
            List<class_1860> allSortedRecipes = this.getAllSortedRecipes();
            Collections.reverse(allSortedRecipes);
            this.recipeFunctions.forEach(recipeFunction -> {
                try {
                    allSortedRecipes.stream().filter(recipe -> recipeFunction.recipeFilter.test((class_1860)recipe)).forEach(t -> this.registerDisplay(recipeFunction.category, (RecipeDisplay)recipeFunction.mappingFunction.apply(t), 0));
                }
                catch (Exception e) {
                    RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to add recipes!", (Throwable)e);
                }
            });
        }
        if (this.getDisplayVisibilityHandlers().isEmpty()) {
            this.registerRecipeVisibilityHandler(new DisplayVisibilityHandler(){

                @Override
                public class_1269 handleDisplay(RecipeCategory<?> category, RecipeDisplay display) {
                    return class_1269.field_5812;
                }

                @Override
                public float getPriority() {
                    return -1.0f;
                }
            });
        }
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        ScreenHelper.getOptionalOverlay().ifPresent(overlay -> {
            overlay.shouldReInit = true;
        });
        long usedTime = System.currentTimeMillis() - startTime;
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Registered %d stack entries, %d recipes displays, %d bounds handler, %d visibility handlers and %d categories (%s) in %d ms.", (Object)RoughlyEnoughItemsCore.getEntryRegistry().getEntryList().size(), (Object)this.recipeCount.get(), (Object)RoughlyEnoughItemsCore.getDisplayHelper().getAllBoundsHandlers().size(), (Object)this.getDisplayVisibilityHandlers().size(), (Object)this.categories.size(), (Object)String.join((CharSequence)", ", this.categories.stream().map(RecipeCategory::getCategoryName).collect(Collectors.toList())), (Object)usedTime);
    }

    @Override
    public AutoTransferHandler registerAutoCraftingHandler(AutoTransferHandler handler) {
        this.autoTransferHandlers.add(handler);
        return handler;
    }

    @Override
    public List<AutoTransferHandler> getSortedAutoCraftingHandler() {
        return this.autoTransferHandlers.stream().sorted(Comparator.comparingDouble(AutoTransferHandler::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public int getRecipeCount() {
        return this.recipeCount.get();
    }

    @Override
    public List<class_1860> getAllSortedRecipes() {
        return this.getRecipeManager().method_8126().stream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getAllRecipes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        this.categories.forEach(recipeCategory -> {
            List list;
            if (this.recipeCategoryListMap.containsKey(recipeCategory.getIdentifier()) && !(list = this.recipeCategoryListMap.get(recipeCategory.getIdentifier()).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList())).isEmpty()) {
                map.put(recipeCategory, list);
            }
        });
        return map;
    }

    @Override
    public List<RecipeDisplay> getAllRecipesFromCategory(RecipeCategory category) {
        return this.recipeCategoryListMap.get(category.getIdentifier());
    }

    @Override
    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.add(visibilityHandler);
    }

    @Override
    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.remove(visibilityHandler);
    }

    @Override
    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers() {
        return Collections.unmodifiableList(this.displayVisibilityHandlers);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display, boolean respectConfig) {
        return this.isDisplayVisible(display);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display) {
        RecipeCategory category = this.getCategory(display.getRecipeCategory());
        List list = this.getDisplayVisibilityHandlers().stream().sorted(VISIBILITY_HANDLER_COMPARATOR).collect(Collectors.toList());
        for (DisplayVisibilityHandler displayVisibilityHandler : list) {
            try {
                class_1269 visibility = displayVisibilityHandler.handleDisplay(category, display);
                if (visibility == class_1269.field_5811) continue;
                return visibility == class_1269.field_5812;
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to check if the recipe is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public void registerScreenClickArea(Rectangle rectangle, Class<? extends class_465> screenClass, class_2960 ... categories) {
        this.screenClickAreas.add(new ScreenClickAreaImpl(screenClass, rectangle, categories));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Class<T> recipeClass, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipe -> recipeClass.isAssignableFrom(recipe.getClass()), mappingFunction));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Function<class_1860, Boolean> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter::apply, mappingFunction));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Predicate<class_1860> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter, mappingFunction));
    }

    @Override
    public void registerLiveRecipeGenerator(LiveRecipeGenerator<?> liveRecipeGenerator) {
        this.liveRecipeGenerators.add(liveRecipeGenerator);
    }

    @Override
    public List<RecipeHelper.ScreenClickArea> getScreenClickAreas() {
        return this.screenClickAreas;
    }

    static {
        RECIPE_COMPARATOR = (o1, o2) -> {
            int int_1 = o1.method_8114().method_12836().compareTo(o2.method_8114().method_12836());
            if (int_1 == 0) {
                int_1 = o1.method_8114().method_12832().compareTo(o2.method_8114().method_12832());
            }
            return int_1;
        };
        Comparator<DisplayVisibilityHandler> comparator = Comparator.comparingDouble(DisplayVisibilityHandler::getPriority);
        VISIBILITY_HANDLER_COMPARATOR = comparator.reversed();
    }

    private class RecipeFunction {
        class_2960 category;
        Predicate<class_1860> recipeFilter;
        Function mappingFunction;

        public RecipeFunction(class_2960 category, Predicate<class_1860> recipeFilter, Function<?, RecipeDisplay> mappingFunction) {
            this.category = category;
            this.recipeFilter = recipeFilter;
            this.mappingFunction = mappingFunction;
        }
    }

    private class ScreenClickAreaImpl
    implements RecipeHelper.ScreenClickArea {
        Class<? extends class_465> screenClass;
        Rectangle rectangle;
        class_2960[] categories;

        private ScreenClickAreaImpl(Class<? extends class_465> screenClass, Rectangle rectangle, class_2960[] categories) {
            this.screenClass = screenClass;
            this.rectangle = rectangle;
            this.categories = categories;
        }

        @Override
        public Class<? extends class_465> getScreenClass() {
            return this.screenClass;
        }

        @Override
        public Rectangle getRectangle() {
            return this.rectangle;
        }

        @Override
        public class_2960[] getCategories() {
            return this.categories;
        }
    }
}

