/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.annotations.Internal;

@Internal
public class CollectionUtils {
    public static final <T> T findFirstOrNullEquals(List<T> list, T obj) {
        for (T t : list) {
            if (!t.equals(obj)) continue;
            return t;
        }
        return null;
    }

    public static final <T> T findFirstOrNull(List<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static final <T> boolean anyMatch(List<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static final boolean anyMatchEqualsAll(List<EntryStack> list, EntryStack stack) {
        for (EntryStack t : list) {
            if (!t.equalsAll(stack)) continue;
            return true;
        }
        return false;
    }

    public static final <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        LinkedList<T> l = null;
        for (T t : list) {
            if (!predicate.test(t)) continue;
            if (l == null) {
                l = new LinkedList<T>();
            }
            l.add(t);
        }
        return l == null ? Collections.emptyList() : l;
    }

    public static final <T, R> List<R> map(List<T> list, Function<T, R> function) {
        LinkedList<R> l = new LinkedList<R>();
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static final <T, R> List<R> map(T[] list, Function<T, R> function) {
        LinkedList<R> l = new LinkedList<R>();
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    public static final <T, R> Optional<R> mapAndMax(List<T> list, Function<T, R> function, Comparator<R> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        List<R> copyOf = CollectionUtils.map(list, function);
        copyOf.sort(comparator);
        return Optional.ofNullable(copyOf.get(copyOf.size() - 1));
    }

    public static final <T, R> Optional<R> mapAndMax(T[] list, Function<T, R> function, Comparator<R> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        List<R> copyOf = CollectionUtils.map(list, function);
        copyOf.sort(comparator);
        return Optional.ofNullable(copyOf.get(copyOf.size() - 1));
    }

    public static final <T> Optional<T> max(List<T> list, Comparator<T> comparator) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<T> ts = new ArrayList<T>(list);
        ts.sort(comparator);
        return Optional.ofNullable(ts.get(ts.size() - 1));
    }

    public static final <T> Optional<T> max(T[] list, Comparator<T> comparator) {
        if (list.length <= 0) {
            return Optional.empty();
        }
        Object[] copyOf = (Object[])list.clone();
        Arrays.sort(copyOf, comparator);
        return Optional.ofNullable(copyOf[copyOf.length - 1]);
    }

    public static final String joinToString(List<String> list, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (String t : list) {
            joiner.add(t);
        }
        return joiner.toString();
    }

    public static final String joinToString(String[] list, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (String t : list) {
            joiner.add(t);
        }
        return joiner.toString();
    }

    public static final <T> String mapAndJoinToString(List<T> list, Function<T, String> function, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public static final <T> String mapAndJoinToString(T[] list, Function<T, String> function, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public static final <T, R> List<R> filterAndMap(List<T> list, Predicate<T> predicate, Function<T, R> function) {
        LinkedList<R> l = null;
        for (T t : list) {
            if (!predicate.test(t)) continue;
            if (l == null) {
                l = new LinkedList<R>();
            }
            l.add(function.apply(t));
        }
        return l == null ? Collections.emptyList() : l;
    }

    public static final <T> int sumInt(List<T> list, Function<T, Integer> function) {
        int sum = 0;
        for (T t : list) {
            sum += function.apply(t).intValue();
        }
        return sum;
    }

    public static final <T> double sumDouble(List<T> list, Function<T, Double> function) {
        double sum = 0.0;
        for (T t : list) {
            sum += function.apply(t).doubleValue();
        }
        return sum;
    }
}

