/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.subsets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.subsets.SubsetsRegistry;
import me.shedaniel.rei.gui.subsets.SubsetsMenuEntry;
import me.shedaniel.rei.gui.subsets.entries.EntryStackMenuEntry;
import me.shedaniel.rei.gui.subsets.entries.SubMenuEntry;
import me.shedaniel.rei.gui.widget.ScrollingContainer;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_364;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubsetsMenu
extends WidgetWithBounds {
    public final Point menuStartPoint;
    private final List<SubsetsMenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (SubsetsMenuEntry entry : SubsetsMenu.this.children()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        @Override
        public Rectangle getBounds() {
            return SubsetsMenu.this.getInnerBounds();
        }

        @Override
        public boolean hasScrollBar() {
            return SubsetsMenu.this.hasScrollBar();
        }
    };

    public SubsetsMenu(Point menuStartPoint, Collection<SubsetsMenuEntry> entries) {
        this.menuStartPoint = menuStartPoint;
        this.buildEntries(entries);
    }

    public static SubsetsMenu createFromRegistry(Point menuStartPoint) {
        List<EntryStack> stacks = EntryRegistry.getInstance().getStacksList();
        HashMap entries = Maps.newHashMap();
        Map<String, Object> allEntries = SubsetsMenu.getOrCreateSubEntryInMap(entries, "roughlyenoughitems:all_entries");
        for (EntryStack stack : stacks) {
            SubsetsMenu.putEntryInMap(allEntries, stack);
        }
        Map<String, Object> itemGroups = SubsetsMenu.getOrCreateSubEntryInMap(entries, "roughlyenoughitems:item_groups");
        for (class_1792 item : class_2378.field_11142) {
            class_1761 group = item.method_7859();
            if (group == null) continue;
            try {
                EntryRegistryImpl.DefaultedLinkedList<Object> list = new EntryRegistryImpl.DefaultedLinkedList<Object>(Lists.newLinkedList(), null);
                item.method_7850(group, list);
                if (list.isEmpty()) {
                    list.add(item.method_7854());
                }
                Map<String, Object> groupMenu = SubsetsMenu.getOrCreateSubEntryInMap(itemGroups, "_item_group_" + group.method_7746());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    class_1799 stack = (class_1799)iterator.next();
                    SubsetsMenu.putEntryInMap(groupMenu, EntryStack.create(stack));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Set<String> paths = SubsetsRegistry.INSTANCE.getPaths();
        for (String path : paths) {
            Map<Object, Object> lastMap = entries;
            String[] pathSegments = path.split("/");
            for (String pathSegment : pathSegments) {
                lastMap = SubsetsMenu.getOrCreateSubEntryInMap(lastMap, pathSegment);
            }
            for (EntryStack entry : SubsetsRegistry.INSTANCE.getPathEntries(path)) {
                EntryStack firstStack = CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(stacks, entry);
                if (firstStack == null) continue;
                SubsetsMenu.putEntryInMap((Map<String, Object>)lastMap, firstStack);
            }
        }
        return new SubsetsMenu(menuStartPoint, SubsetsMenu.buildEntries(entries));
    }

    private static Map<String, Object> getOrCreateSubEntryInMap(Map<String, Object> parent, String pathSegment) {
        SubsetsMenu.putEntryInMap(parent, pathSegment);
        return (Map)parent.get(pathSegment);
    }

    private static void putEntryInMap(Map<String, Object> parent, String pathSegment) {
        if (!parent.containsKey(pathSegment)) {
            parent.put(pathSegment, Maps.newHashMap());
        }
    }

    private static void putEntryInMap(Map<String, Object> parent, EntryStack stack) {
        Set items = (Set)parent.get("items");
        if (items == null) {
            items = Sets.newLinkedHashSet();
            parent.put("items", items);
        }
        items.add(stack);
    }

    private static List<SubsetsMenuEntry> buildEntries(Map<String, Object> map) {
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals("items")) {
                Set items = (Set)entry.getValue();
                for (EntryStack item : items) {
                    entries.add(new EntryStackMenuEntry(item));
                }
                continue;
            }
            Map entryMap = (Map)entry.getValue();
            if (entry.getKey().startsWith("_item_group_")) {
                entries.add(new SubMenuEntry(class_1074.method_4662((String)entry.getKey().replace("_item_group_", "itemGroup."), (Object[])new Object[0]), SubsetsMenu.buildEntries(entryMap)));
                continue;
            }
            String translationKey = "subsets.rei." + entry.getKey().replace(':', '.');
            if (!class_1074.method_4663((String)translationKey)) {
                RoughlyEnoughItemsCore.LOGGER.warn("Subsets menu " + translationKey + " does not have a translation");
            }
            entries.add(new SubMenuEntry(class_1074.method_4662((String)translationKey, (Object[])new Object[0]), SubsetsMenu.buildEntries(entryMap)));
        }
        return entries;
    }

    private void buildEntries(Collection<SubsetsMenuEntry> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        this.entries.sort(Comparator.comparing(entry -> entry instanceof SubMenuEntry ? 0 : 1).thenComparing(entry -> entry instanceof SubMenuEntry ? ((SubMenuEntry)((Object)((Object)entry))).text : ""));
        for (SubsetsMenuEntry entry2 : this.entries) {
            entry2.parent = this;
        }
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight() + 2);
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.menuStartPoint.x + 1, this.menuStartPoint.y + 1, this.getMaxEntryWidth() + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight());
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight();
    }

    public int getInnerHeight() {
        return Math.min(this.scrolling.getMaxScrollHeight(), this.minecraft.field_1755.height - 20 - this.menuStartPoint.y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (SubsetsMenuEntry entry : this.children()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void render(int mouseX, int mouseY, float delta) {
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        SubsetsMenu.fill((int)bounds.x, (int)bounds.y, (int)bounds.getMaxX(), (int)bounds.getMaxY(), (int)-6250336);
        SubsetsMenu.fill((int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)-16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        SubsetsMenuEntry focused = this.getFocused() instanceof SubsetsMenuEntry ? (SubsetsMenuEntry)this.getFocused() : null;
        int currentY = (int)((double)innerBounds.y - this.scrolling.scrollAmount);
        for (SubsetsMenuEntry child : this.children()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = (int)((double)innerBounds.y - this.scrolling.scrollAmount);
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getScissorBounds());
        for (SubsetsMenuEntry child : this.children()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.render(mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.setFocused((class_364)focused);
        this.scrolling.renderScrollBar();
        this.scrolling.updatePosition(delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        for (SubsetsMenuEntry child : this.children()) {
            if (!(child instanceof SubMenuEntry) || !child.mouseScrolled(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    public List<SubsetsMenuEntry> children() {
        return this.entries;
    }
}

