/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.subsets.entries;

import java.util.Collections;
import java.util.List;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.subsets.SubsetsMenu;
import me.shedaniel.rei.gui.subsets.SubsetsMenuEntry;
import me.shedaniel.rei.gui.subsets.entries.SubMenuEntry;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class EntryStackMenuEntry
extends SubsetsMenuEntry {
    final EntryStack stack;
    private int x;
    private int y;
    private int width;
    private boolean selected;
    private boolean containsMouse;
    private boolean rendering;
    private boolean clickedLast = false;
    private Boolean isFiltered = null;

    public EntryStackMenuEntry(EntryStack stack) {
        this.stack = stack;
    }

    @Override
    public int getEntryWidth() {
        return 18;
    }

    @Override
    public int getEntryHeight() {
        return 18;
    }

    @Override
    public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
        this.x = xPos;
        this.y = yPos;
        this.selected = selected;
        this.containsMouse = containsMouse;
        this.rendering = rendering;
        this.width = width;
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (this.isFiltered()) {
            if (this.selected) {
                EntryStackMenuEntry.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 18), (int)-26215);
            } else {
                EntryStackMenuEntry.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 18), (int)-65536);
            }
        } else if (this.selected) {
            EntryStackMenuEntry.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 18), (int)0x45FFFFFF);
        }
        if (this.containsMouse && mouseX >= this.x + this.width / 2 - 8 && mouseX <= this.x + this.width / 2 + 8 && mouseY >= this.y + 1 && mouseY <= this.y + 17) {
            ScreenHelper.getLastOverlay().addTooltip(this.stack.getTooltip(mouseX, mouseY));
            if (RoughlyEnoughItemsCore.isLeftModePressed && !this.clickedLast) {
                this.clickedLast = true;
                if (!this.getParent().scrolling.draggingScrollBar) {
                    this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    List<EntryStack> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
                    if (this.isFiltered()) {
                        filteredStacks.removeIf(next -> next.equalsIgnoreAmount(this.stack));
                    } else {
                        filteredStacks.add(this.stack.copy());
                    }
                    SubsetsMenu subsetsMenu = ScreenHelper.getLastOverlay().getSubsetsMenu();
                    if (subsetsMenu != null) {
                        this.recalculateFilter(subsetsMenu);
                    }
                    ConfigManager.getInstance().saveConfig();
                    ((EntryRegistryImpl)EntryRegistry.getInstance()).refilter();
                    if (ScreenHelper.getSearchField() != null) {
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText(), true);
                    }
                }
            } else if (!RoughlyEnoughItemsCore.isLeftModePressed) {
                this.clickedLast = false;
            }
        } else {
            this.clickedLast = false;
        }
        this.stack.render(new Rectangle(this.x + this.width / 2 - 8, this.y + 1, 16, 16), mouseX, mouseY, delta);
    }

    void recalculateFilter(SubsetsMenu menu) {
        for (SubsetsMenuEntry child : menu.children()) {
            if (child instanceof SubMenuEntry && ((SubMenuEntry)child).getSubsetsMenu() != null) {
                this.recalculateFilter(((SubMenuEntry)child).getSubsetsMenu());
                continue;
            }
            if (!(child instanceof EntryStackMenuEntry) || !((EntryStackMenuEntry)child).stack.equalsIgnoreAmount(this.stack)) continue;
            ((EntryStackMenuEntry)child).isFiltered = null;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 18);
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public boolean isFiltered() {
        List<EntryStack> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
        if (this.isFiltered == null) {
            this.isFiltered = CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(filteredStacks, this.stack) != null;
        }
        return this.isFiltered;
    }
}

