/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.util.Collections;
import java.util.List;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TabWidget
extends WidgetWithBounds {
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final class_2960 CHEST_GUI_TEXTURE_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    public boolean shown = false;
    public boolean selected = false;
    public EntryStack logo;
    public int id;
    public String categoryName;
    public Rectangle bounds;
    public RecipeCategory<?> category;
    public int u;
    public int v;

    public TabWidget(int id, Rectangle bounds) {
        this(id, bounds, 0, 192);
    }

    public TabWidget(int id, Rectangle bounds, int u, int v) {
        this.id = id;
        this.bounds = bounds;
        this.u = u;
        this.v = v;
    }

    public TabWidget(int id, int tabSize, int leftX, int bottomY) {
        this(id, new Rectangle(leftX + id * tabSize, bottomY - tabSize, tabSize, tabSize));
    }

    public TabWidget(int id, int tabSize, int leftX, int bottomY, int u, int v) {
        this(id, new Rectangle(leftX + id * tabSize, bottomY - tabSize, tabSize, tabSize), u, v);
    }

    public void setRenderer(RecipeCategory<?> category, EntryStack logo, String categoryName, boolean selected) {
        if (logo == null) {
            this.shown = false;
            this.logo = null;
        } else {
            this.shown = true;
            this.logo = logo;
        }
        this.category = category;
        this.selected = selected;
        this.categoryName = categoryName;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getId() {
        return this.id;
    }

    public boolean isShown() {
        return this.shown;
    }

    public List<Widget> children() {
        return Collections.emptyList();
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (this.shown) {
            this.minecraft.method_1531().method_22813(ScreenHelper.isDarkModeEnabled() ? CHEST_GUI_TEXTURE_DARK : CHEST_GUI_TEXTURE);
            this.blit(this.bounds.x, this.bounds.y + 2, this.u + (this.selected ? this.bounds.width : 0), this.v, this.bounds.width, this.selected ? this.bounds.height + 2 : this.bounds.height - 1);
            this.logo.setZ(100);
            this.logo.render(new Rectangle(this.bounds.getCenterX() - 8, this.bounds.getCenterY() - 5, 16, 16), mouseX, mouseY, delta);
            if (this.containsMouse(mouseX, mouseY)) {
                this.drawTooltip();
            }
        }
    }

    private void drawTooltip() {
        if (this.minecraft.field_1690.field_1827) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.categoryName, class_124.field_1063.toString() + this.category.getIdentifier().toString(), ClientHelper.getInstance().getFormattedModFromIdentifier(this.category.getIdentifier())));
        } else {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.categoryName, ClientHelper.getInstance().getFormattedModFromIdentifier(this.category.getIdentifier())));
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
}

