/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SearchArgument {
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final SearchArgument ALWAYS = new SearchArgument(ArgumentType.ALWAYS, "", true);
    private static List<class_1792> searchBlacklisted = Lists.newArrayList();
    private ArgumentType argumentType;
    private String text;
    public final Function<String, Boolean> INCLUDE = s -> s.contains(this.text);
    public final Function<String, Boolean> NOT_INCLUDE = s -> !s.contains(this.text);
    private boolean include;

    public SearchArgument(ArgumentType argumentType, String text, boolean include) {
        this(argumentType, text, include, true);
    }

    public SearchArgument(ArgumentType argumentType, String text, boolean include, boolean autoLowerCase) {
        this.argumentType = argumentType;
        this.text = autoLowerCase ? text.toLowerCase(Locale.ROOT) : text;
        this.include = include;
    }

    @ApiStatus.Internal
    public static List<SearchArguments> processSearchTerm(String searchTerm) {
        ArrayList searchArguments = Lists.newArrayList();
        for (String split : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm.toLowerCase(Locale.ROOT), (String)"|")) {
            String[] terms = StringUtils.split((String)split);
            if (terms.length == 0) {
                searchArguments.add(SearchArguments.ALWAYS);
                continue;
            }
            SearchArgument[] arguments = new SearchArgument[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                String term = terms[i];
                arguments[i] = term.startsWith("-@") || term.startsWith("@-") ? new SearchArgument(ArgumentType.MOD, term.substring(2), false) : (term.startsWith("@") ? new SearchArgument(ArgumentType.MOD, term.substring(1), true) : (term.startsWith("-$") || term.startsWith("$-") ? new SearchArgument(ArgumentType.TAG, term.substring(2), false) : (term.startsWith("$") ? new SearchArgument(ArgumentType.TAG, term.substring(1), true) : (term.startsWith("-#") || term.startsWith("#-") ? new SearchArgument(ArgumentType.TOOLTIP, term.substring(2), false) : (term.startsWith("#") ? new SearchArgument(ArgumentType.TOOLTIP, term.substring(1), true) : (term.startsWith("-") ? new SearchArgument(ArgumentType.TEXT, term.substring(1), false) : new SearchArgument(ArgumentType.TEXT, term, true)))))));
            }
            searchArguments.add(new SearchArguments(arguments));
        }
        return searchArguments;
    }

    @ApiStatus.Internal
    public static boolean canSearchTermsBeAppliedTo(EntryStack stack, List<SearchArguments> searchArguments) {
        if (searchArguments.isEmpty()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        String mod = null;
        String modName = null;
        String name = null;
        String tooltip = null;
        String[] tags = null;
        for (SearchArguments arguments : searchArguments) {
            boolean applicable = true;
            for (SearchArgument argument : arguments.getArguments()) {
                if (argument.getArgumentType() == ArgumentType.ALWAYS) {
                    return true;
                }
                if (argument.getArgumentType() == ArgumentType.MOD) {
                    if (mod == null) {
                        mod = stack.getIdentifier().map(class_2960::method_12836).orElse(EMPTY).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (mod == null || mod.isEmpty() || !argument.getFunction(!argument.isInclude()).apply(mod).booleanValue()) continue;
                    if (modName == null) {
                        modName = ClientHelper.getInstance().getModFromModId(mod).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (modName != null && !modName.isEmpty() && !argument.getFunction(!argument.isInclude()).apply(modName).booleanValue()) break;
                    applicable = false;
                    break;
                }
                if (argument.getArgumentType() == ArgumentType.TEXT) {
                    if (name == null) {
                        name = SearchArgument.tryGetEntryStackName(stack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (name == null || name.isEmpty() || !argument.getFunction(!argument.isInclude()).apply(name).booleanValue()) continue;
                    applicable = false;
                    break;
                }
                if (argument.getArgumentType() == ArgumentType.TOOLTIP) {
                    if (tooltip == null) {
                        tooltip = SearchArgument.tryGetEntryStackTooltip(stack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (tooltip == null || tooltip.isEmpty() || !argument.getFunction(!argument.isInclude()).apply(tooltip).booleanValue()) continue;
                    applicable = false;
                    break;
                }
                if (argument.getArgumentType() != ArgumentType.TAG) continue;
                if (tags == null) {
                    if (stack.getType() == EntryStack.Type.ITEM) {
                        class_2960[] tagsFor = minecraft.method_1562().method_2867().method_15201().method_15191((Object)stack.getItem()).toArray(new class_2960[0]);
                        tags = new String[tagsFor.length];
                        for (int i = 0; i < tagsFor.length; ++i) {
                            tags[i] = tagsFor[i].toString();
                        }
                    } else if (stack.getType() == EntryStack.Type.FLUID) {
                        class_2960[] tagsFor = minecraft.method_1562().method_2867().method_15205().method_15191((Object)stack.getFluid()).toArray(new class_2960[0]);
                        tags = new String[tagsFor.length];
                        for (int i = 0; i < tagsFor.length; ++i) {
                            tags[i] = tagsFor[i].toString();
                        }
                    } else {
                        tags = new String[]{};
                    }
                }
                if (tags != null && tags.length > 0) {
                    boolean a = false;
                    for (String tag : tags) {
                        if (!argument.getFunction(argument.isInclude()).apply(tag).booleanValue()) continue;
                        a = true;
                    }
                    if (a) continue;
                    applicable = false;
                    break;
                }
                applicable = false;
                break;
            }
            if (!applicable) continue;
            return true;
        }
        return false;
    }

    public static String tryGetEntryStackName(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return SearchArgument.tryGetItemStackName(stack.getItemStack());
        }
        if (stack.getType() == EntryStack.Type.FLUID) {
            return SearchArgument.tryGetFluidName(stack.getFluid());
        }
        QueuedTooltip tooltip = stack.getTooltip(PointHelper.getMouseX(), PointHelper.getMouseY());
        if (tooltip != null) {
            return tooltip.getText().isEmpty() ? EMPTY : tooltip.getText().get(0);
        }
        return EMPTY;
    }

    public static String tryGetEntryStackNameNoFormatting(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return SearchArgument.tryGetItemStackNameNoFormatting(stack.getItemStack());
        }
        if (stack.getType() == EntryStack.Type.FLUID) {
            return SearchArgument.tryGetFluidName(stack.getFluid());
        }
        QueuedTooltip tooltip = stack.getTooltip(PointHelper.getMouseX(), PointHelper.getMouseY());
        if (tooltip != null) {
            return tooltip.getText().isEmpty() ? EMPTY : tooltip.getText().get(0);
        }
        return EMPTY;
    }

    public static String tryGetEntryStackTooltip(EntryStack stack) {
        QueuedTooltip tooltip = stack.getTooltip(0, 0);
        if (tooltip != null) {
            return CollectionUtils.joinToString(tooltip.getText(), "\n");
        }
        return EMPTY;
    }

    public static String tryGetFluidName(class_3611 fluid) {
        class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
        if (class_1074.method_4663((String)("block." + id.toString().replaceFirst(":", ".")))) {
            return class_1074.method_4662((String)("block." + id.toString().replaceFirst(":", ".")), (Object[])new Object[0]);
        }
        return CollectionUtils.mapAndJoinToString(id.method_12832().split("_"), StringUtils::capitalize, SPACE);
    }

    public static List<String> tryGetItemStackToolTip(class_1799 itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.method_7909())) {
            try {
                return CollectionUtils.map(itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934)), class_2561::method_10863);
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.method_7909());
            }
        }
        return Collections.singletonList(SearchArgument.tryGetItemStackName(itemStack));
    }

    public static String tryGetItemStackName(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909())) {
            try {
                return stack.method_7964().method_10863();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        }
        try {
            return class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)stack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static String tryGetItemStackNameNoFormatting(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909())) {
            try {
                return stack.method_7964().method_10851();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        }
        try {
            return class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)stack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public Function<String, Boolean> getFunction(boolean include) {
        return include ? this.INCLUDE : this.NOT_INCLUDE;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isInclude() {
        return this.include;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, include = %b", this.argumentType.name(), this.text, this.include);
    }

    static /* synthetic */ SearchArgument access$000() {
        return ALWAYS;
    }

    public static class SearchArguments {
        public static final SearchArguments ALWAYS = new SearchArguments(new SearchArgument[]{SearchArgument.access$000()});
        private SearchArgument[] arguments;

        public SearchArguments(SearchArgument[] arguments) {
            this.arguments = arguments;
        }

        public SearchArgument[] getArguments() {
            return this.arguments;
        }
    }

    public static enum ArgumentType {
        TEXT,
        MOD,
        TOOLTIP,
        TAG,
        ALWAYS;

    }
}

