/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.jankson;

import blue.endless.jankson.JsonElement;
import blue.endless.jankson.impl.Marshaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonArray
extends JsonElement
implements Collection<JsonElement>,
Iterable<JsonElement> {
    private List<Entry> entries = new ArrayList<Entry>();
    protected Marshaller marshaller = Marshaller.getFallback();

    public JsonArray() {
    }

    public <T> JsonArray(T[] ts, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (T t : ts) {
            this.add(marshaller.serialize(t));
        }
    }

    public JsonArray(Collection<?> ts, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (Object t : ts) {
            this.add(marshaller.serialize(t));
        }
    }

    public JsonElement get(int i) {
        return this.entries.get((int)i).value;
    }

    public String getComment(int i) {
        return this.entries.get((int)i).comment;
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        int j;
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        if (newlines) {
            builder.append('\n');
            for (j = 0; j < depth + 1; ++j) {
                builder.append("\t");
            }
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int j2;
            Entry entry = this.entries.get(i);
            if (entry.comment != null) {
                builder.append("/* ");
                builder.append(entry.comment);
                builder.append(" */ ");
                if (newlines) {
                    builder.append('\n');
                    for (j2 = 0; j2 < depth + 1; ++j2) {
                        builder.append("\t");
                    }
                }
            }
            builder.append(entry.value.toJson(comments, newlines, depth + 1));
            if (i >= this.entries.size() - 1) continue;
            if (newlines) {
                builder.append(",\n");
                for (j2 = 0; j2 < depth + 1; ++j2) {
                    builder.append("\t");
                }
                continue;
            }
            builder.append(", ");
        }
        if (this.entries.size() > 0) {
            if (newlines) {
                builder.append('\n');
                for (j = 0; j < depth; ++j) {
                    builder.append("\t");
                }
            } else {
                builder.append(' ');
            }
        }
        builder.append(']');
        return builder.toString();
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    public boolean add(@Nonnull JsonElement e, String comment) {
        if (this.contains(e)) {
            return false;
        }
        Entry entry = new Entry();
        entry.value = e;
        entry.comment = comment;
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof JsonArray)) {
            return false;
        }
        List<Entry> a = this.entries;
        List<Entry> b = ((JsonArray)other).entries;
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            Entry ae = a.get(i);
            Entry be = b.get(i);
            if (!ae.value.equals(be.value)) {
                return false;
            }
            if (Objects.equals(ae.comment, be.comment)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, int index) {
        JsonElement elem = this.get(index);
        return this.marshaller.marshall(clazz, elem);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public JsonArray clone() {
        JsonArray result = new JsonArray();
        result.marshaller = this.marshaller;
        for (Entry entry : this.entries) {
            result.add(entry.value.clone(), entry.comment);
        }
        return result;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean add(@Nonnull JsonElement e) {
        Entry entry = new Entry();
        entry.value = e;
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends JsonElement> c) {
        boolean result = false;
        for (JsonElement jsonElement : c) {
            result |= this.add(jsonElement);
        }
        return result;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || !(o instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry cur = this.entries.get(i);
            if (!cur.value.equals(o)) continue;
            this.entries.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll not supported");
    }

    public JsonElement[] toArray() {
        JsonElement[] result = new JsonElement[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            result[i] = this.entries.get((int)i).value;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.entries.size()) {
            a = new Object[this.entries.size()];
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            a[i] = this.entries.get((int)i).value;
        }
        if (a.length > this.entries.size()) {
            a[this.entries.size()] = null;
        }
        return a;
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return new EntryIterator(this.entries);
    }

    private static class Entry {
        String comment;
        JsonElement value;

        private Entry() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry o = (Entry)other;
            return Objects.equals(this.comment, o.comment) && Objects.equals(this.value, o.value);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.value);
        }
    }

    private static class EntryIterator
    implements Iterator<JsonElement> {
        private final Iterator<Entry> delegate;

        public EntryIterator(List<Entry> list) {
            this.delegate = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public JsonElement next() {
            return this.delegate.next().value;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

