/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsPlugin;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.ConfigManager;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.KeyBindHelper;
import me.shedaniel.rei.client.RecipeHelperImpl;
import me.shedaniel.rei.gui.ContainerGuiOverlay;
import me.shedaniel.rei.gui.config.ConfigGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RoughlyEnoughItemsClient {
    public static void setup() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        RoughlyEnoughItemsCore.configManager = new ConfigManager();
        KeyBindHelper.setupKeyBinds();
        RoughlyEnoughItemsPlugin.discoverPlugins();
        ModList.get().getModContainerById("roughlyenoughitems").ifPresent(c -> c.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> new ConfigGui((GuiScreen)parent)));
        eventBus.addListener(EventPriority.NORMAL, true, TickEvent.ClientTickEvent.class, GuiHelper::clientTick);
        eventBus.register(RoughlyEnoughItemsClient.class);
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        ((RecipeHelperImpl)RoughlyEnoughItemsCore.getRecipeHelper()).recipesLoaded(Minecraft.func_71410_x().func_147114_u().func_199526_e());
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)event.getGui();
            if (container instanceof GuiContainerCreative && ((GuiContainerCreative)container).func_147056_g() != ItemGroup.field_78036_m.func_78021_a()) {
                return;
            }
            GuiHelper.setLastGuiContainer(container);
            container.func_195074_b().add(GuiHelper.getLastOverlay(true, false));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)event.getGui();
            if (container instanceof GuiContainerCreative && ((GuiContainerCreative)container).func_147056_g() != ItemGroup.field_78036_m.func_78021_a()) {
                return;
            }
            GuiHelper.getLastOverlay().renderOverlay(event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            if (((GuiContainerCreative)event.getGui()).func_147056_g() != ItemGroup.field_78036_m.func_78021_a()) {
                return;
            }
            if (GuiHelper.getLastOverlay().mouseClicked(event.getMouseX(), event.getMouseY(), event.getButton())) {
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative && ((GuiContainerCreative)event.getGui()).func_147056_g() != ItemGroup.field_78036_m.func_78021_a()) {
            return;
        }
        if (event.getGui() instanceof GuiContainer && GuiHelper.getLastOverlay().keyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMouseScrolled(GuiScreenEvent.MouseScrollEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative && ((GuiContainerCreative)event.getGui()).func_147056_g() != ItemGroup.field_78036_m.func_78021_a()) {
            return;
        }
        if (event.getGui() instanceof GuiContainer) {
            ContainerGuiOverlay overlay = GuiHelper.getLastOverlay();
            if (GuiHelper.isOverlayVisible() && overlay.getRectangle().contains(ClientHelper.getMouseLocation()) && overlay.mouseScrolled(event.getScrollDelta())) {
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCharTyped(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            if (((GuiContainerCreative)event.getGui()).func_147056_g() != ItemGroup.field_78036_m.func_78021_a()) {
                return;
            }
            GuiContainerCreative containerCreative = (GuiContainerCreative)event.getGui();
            ContainerGuiOverlay overlay = GuiHelper.getLastOverlay();
            if (GuiHelper.isOverlayVisible() && containerCreative.func_147056_g() == ItemGroup.field_78036_m.func_78021_a() && overlay.charTyped(event.getCodePoint(), event.getModifiers())) {
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
            }
        } else if (event.getGui() instanceof GuiInventory || event.getGui() instanceof GuiCrafting) {
            GuiContainer container = (GuiContainer)event.getGui();
            ContainerGuiOverlay overlay = GuiHelper.getLastOverlay();
            if (GuiHelper.isOverlayVisible() && overlay.charTyped(event.getCodePoint(), event.getModifiers())) {
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiShift(GuiScreenEvent.PotionShiftEvent event) {
        event.setCanceled(true);
    }
}

