/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Maps;
import com.google.gson.JsonParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.IREIPlugin;
import me.shedaniel.rei.api.REIPlugin;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoughlyEnoughItemsPlugin {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");
    private static final Map<ResourceLocation, REIPlugin> plugins = Maps.newHashMap();
    private static JsonParser parser = new JsonParser();
    private static boolean loaded = false;

    public static REIPlugin registerPlugin(ResourceLocation location, REIPlugin plugin) {
        plugins.put(location, plugin);
        LOGGER.info("Registered Plugin from %s by %s.", (Object)location.toString(), (Object)plugin.getClass().getSimpleName());
        plugin.onFirstLoad(RoughlyEnoughItemsCore.getPluginDisabler());
        return plugin;
    }

    public static List<REIPlugin> getPlugins() {
        return new LinkedList<REIPlugin>(plugins.values());
    }

    public static Optional<ResourceLocation> getPluginLocation(REIPlugin plugin) {
        for (ResourceLocation location : plugins.keySet()) {
            if (location == null || !plugins.get(location).equals(plugin)) continue;
            return Optional.of(location);
        }
        return Optional.empty();
    }

    public static void discoverPlugins() {
        if (loaded) {
            return;
        }
        loaded = true;
        LOGGER.info("Discovering Plugins.");
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(a -> {
            String required;
            if (a.getAnnotationType().getClassName().equals(IREIPlugin.class.getName()) && ((required = a.getAnnotationData().getOrDefault("value", "")).isEmpty() || ModList.get().isLoaded(required))) {
                try {
                    Class<?> clazz = Class.forName(a.getMemberName());
                    if (REIPlugin.class.isAssignableFrom(clazz)) {
                        REIPlugin plugin = (REIPlugin)clazz.newInstance();
                        RoughlyEnoughItemsPlugin.registerPlugin(new ResourceLocation(clazz.getAnnotation(IREIPlugin.class).identifier()), plugin);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Can't load REI plugin. %s", (Object)a.getMemberName());
                }
            }
        }));
        LOGGER.info("Discovered %d REI Plugins%s", (Object)plugins.size(), (Object)(plugins.size() > 0 ? ": " + String.join((CharSequence)", ", plugins.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList())) : "."));
    }
}

