/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.DisplaySettings;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.gui.RecipeViewingGui;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public interface RecipeCategory<T extends RecipeDisplay> {
    public ResourceLocation getLocation();

    public ItemStack getCategoryIcon();

    public String getCategoryName();

    default public List<IWidget> setupDisplay(Supplier<T> recipeDisplaySupplier, Rectangle bounds) {
        return Arrays.asList(new RecipeBaseWidget(bounds));
    }

    default public void drawCategoryBackground(Rectangle bounds, int mouseX, int mouseY, float delta) {
        new RecipeBaseWidget(bounds).draw(mouseX, mouseY, delta);
        Gui.func_73734_a((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)RecipeViewingGui.SUB_COLOR.getRGB());
        Gui.func_73734_a((int)(bounds.x + 17), (int)(bounds.y + 21), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 33), (int)RecipeViewingGui.SUB_COLOR.getRGB());
    }

    default public DisplaySettings getDisplaySettings() {
        return new DisplaySettings<T>(){

            @Override
            public int getDisplayHeight(RecipeCategory category) {
                return 66;
            }

            @Override
            public int getDisplayWidth(RecipeCategory category, T display) {
                return 150;
            }

            @Override
            public int getMaximumRecipePerPage(RecipeCategory category) {
                return 99;
            }
        };
    }

    default public int getDisplayHeight() {
        return this.getDisplaySettings().getDisplayHeight(this);
    }

    default public int getDisplayWidth(T display) {
        return this.getDisplaySettings().getDisplayWidth(this, display);
    }

    default public int getMaximumRecipePerPage() {
        return this.getDisplaySettings().getMaximumRecipePerPage(this);
    }

    default public boolean checkTags() {
        return false;
    }
}

