/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.gui.RecipeViewingGui;
import me.shedaniel.rei.gui.config.ConfigGui;
import me.shedaniel.rei.network.CreateItemsPacket;
import me.shedaniel.rei.network.DeleteItemsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ClientHelper {
    public static String getModFromItemStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ResourceLocation location = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b());
            assert (location != null);
            String modid = location.func_110624_b();
            if (modid.equalsIgnoreCase("minecraft")) {
                return "Minecraft";
            }
            return ModList.get().getMods().stream().filter(modInfo -> modInfo.getModId().equalsIgnoreCase(modid)).map(ModInfo::getDisplayName).findAny().orElse(modid);
        }
        return "";
    }

    public static Point getMouseLocation() {
        Minecraft client = Minecraft.func_71410_x();
        MouseHelper mouse = client.field_71417_B;
        double double_1 = mouse.func_198024_e() * (double)client.field_195558_d.func_198107_o() / (double)client.field_195558_d.func_198105_m();
        double double_2 = mouse.func_198026_f() * (double)client.field_195558_d.func_198087_p() / (double)client.field_195558_d.func_198083_n();
        return new Point((int)double_1, (int)double_2);
    }

    public static boolean isCheating() {
        return RoughlyEnoughItemsCore.getConfigManager().getConfig().cheating;
    }

    public static void setCheating(boolean cheating) {
        RoughlyEnoughItemsCore.getConfigManager().getConfig().cheating = cheating;
        try {
            RoughlyEnoughItemsCore.getConfigManager().saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendDeletePacket() {
        if (GuiHelper.getLastGuiContainer() instanceof GuiContainerCreative) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            return;
        }
        DeleteItemsPacket message = new DeleteItemsPacket();
        Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)message);
    }

    public static boolean tryCheatingStack(ItemStack cheatedStack) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            try {
                CreateItemsPacket message = new CreateItemsPacket(cheatedStack.func_77946_l());
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)message);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        ResourceLocation location = IRegistry.field_212630_s.func_177774_c((Object)cheatedStack.func_77973_b());
        String tagMessage = cheatedStack.func_77946_l().func_77978_p() != null && !cheatedStack.func_77946_l().func_77978_p().isEmpty() ? cheatedStack.func_77946_l().func_77978_p().toString() : "";
        String og = cheatedStack.func_190916_E() != 1 ? RoughlyEnoughItemsCore.getConfigManager().getConfig().giveCommand.replaceAll(" \\{count}", "").replaceAll("\\{count}", "") : RoughlyEnoughItemsCore.getConfigManager().getConfig().giveCommand;
        String madeUpCommand = og.replaceAll("\\{player_name}", Minecraft.func_71410_x().field_71439_g.func_195047_I_()).replaceAll("\\{item_identifier}", location.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.func_190916_E()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", Minecraft.func_71410_x().field_71439_g.func_195047_I_()).replaceAll("\\{item_identifier}", location.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.func_190916_E()));
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("text.rei.too_long_nbt", new Object[0]), false);
        }
        System.out.println(madeUpCommand);
        Minecraft.func_71410_x().field_71439_g.func_71165_d(madeUpCommand);
        return true;
    }

    public static boolean executeRecipeKeyBind(ItemStack stack) {
        Map<RecipeCategory, List<RecipeDisplay>> map = RecipeHelper.getInstance().getRecipesFor(stack);
        if (map.keySet().size() > 0) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new RecipeViewingGui(Minecraft.func_71410_x().field_195558_d, map));
        }
        return map.keySet().size() > 0;
    }

    public static boolean executeUsageKeyBind(ItemStack stack) {
        Map<RecipeCategory, List<RecipeDisplay>> map = RecipeHelper.getInstance().getUsagesFor(stack);
        if (map.keySet().size() > 0) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new RecipeViewingGui(Minecraft.func_71410_x().field_195558_d, map));
        }
        return map.keySet().size() > 0;
    }

    public static void openConfigWindow(GuiScreen parent) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new ConfigGui(parent));
    }

    public static boolean executeViewAllRecipesKeyBind() {
        Map<RecipeCategory, List<RecipeDisplay>> map = RecipeHelper.getInstance().getAllRecipes();
        if (map.keySet().size() > 0) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new RecipeViewingGui(Minecraft.func_71410_x().field_195558_d, map));
        }
        return map.keySet().size() > 0;
    }

    public static List<ItemStack> getInventoryItemsTypes() {
        ImmutableList field_7543 = ImmutableList.of((Object)Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a, (Object)Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70460_b, (Object)Minecraft.func_71410_x().field_71439_g.field_71071_by.field_184439_c);
        ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
        field_7543.forEach(itemStacks -> itemStacks.forEach(itemStack -> {
            if (!itemStack.func_77973_b().equals(Items.field_190931_a)) {
                inventoryStacks.add((ItemStack)itemStack);
            }
        }));
        return inventoryStacks;
    }
}

