/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsPlugin;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.PluginFunction;
import me.shedaniel.rei.api.REIPlugin;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;

public class RecipeHelperImpl
implements RecipeHelper {
    private final AtomicInteger recipeCount = new AtomicInteger();
    private final Map<ResourceLocation, List<RecipeDisplay>> recipeCategoryListMap = Maps.newHashMap();
    private final List<RecipeCategory> categories = Lists.newArrayList();
    private final Map<ResourceLocation, ButtonAreaSupplier> speedCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<ResourceLocation, List<SpeedCraftFunctional>> speedCraftFunctionalMap = Maps.newHashMap();
    private RecipeManager recipeManager;

    @Override
    public List<ItemStack> findCraftableByItems(List<ItemStack> inventoryItems) {
        ArrayList<ItemStack> craftables = new ArrayList<ItemStack>();
        for (List<RecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (RecipeDisplay recipeDisplay : value) {
                int slotsCraftable = 0;
                List<List<ItemStack>> requiredInput = recipeDisplay.getRequiredItems();
                block2: for (List<ItemStack> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    boolean slotDone = false;
                    for (ItemStack possibleType : inventoryItems) {
                        for (ItemStack slotPossible : slot) {
                            if (!ItemStack.func_77989_b((ItemStack)slotPossible, (ItemStack)possibleType)) continue;
                            ++slotsCraftable;
                            slotDone = true;
                            break;
                        }
                        if (!slotDone) continue;
                        continue block2;
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredItems().size()) continue;
                craftables.addAll(recipeDisplay.getOutput());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void registerCategory(RecipeCategory category) {
        this.categories.add(category);
        this.recipeCategoryListMap.put(category.getLocation(), Lists.newLinkedList());
    }

    @Override
    public void registerDisplay(ResourceLocation category, RecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(category)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(category).add(display);
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getRecipesFor(ItemStack stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getLocation(), Lists.newArrayList());
        });
        for (Map.Entry<ResourceLocation, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            for (RecipeDisplay recipeDisplay : entry.getValue()) {
                for (ItemStack outputStack : recipeDisplay.getOutput()) {
                    if (!(category2.checkTags() ? ItemStack.func_77989_b((ItemStack)stack, (ItemStack)outputStack) : ItemStack.func_185132_d((ItemStack)stack, (ItemStack)outputStack))) continue;
                    ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                }
            }
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getLocation()) && !((List)categoriesMap.get(category.getLocation())).isEmpty()) {
                recipeCategoryListMap.put(category, categoriesMap.get(category.getLocation()));
            }
        });
        return recipeCategoryListMap;
    }

    private RecipeCategory getCategory(ResourceLocation location) {
        return this.categories.stream().filter(category -> category.getLocation().equals((Object)location)).findFirst().orElse(null);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getUsagesFor(ItemStack stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getLocation(), Lists.newArrayList());
        });
        for (Map.Entry<ResourceLocation, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            block1: for (RecipeDisplay recipeDisplay : entry.getValue()) {
                boolean found = false;
                for (List<ItemStack> input : recipeDisplay.getInput()) {
                    for (ItemStack itemStack : input) {
                        if (!(category2.checkTags() ? ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)stack) : ItemStack.func_185132_d((ItemStack)itemStack, (ItemStack)stack))) continue;
                        ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getLocation()) && !((List)categoriesMap.get(category.getLocation())).isEmpty()) {
                recipeCategoryListMap.put(category, categoriesMap.get(category.getLocation()));
            }
        });
        return recipeCategoryListMap;
    }

    @Override
    public List<RecipeCategory> getAllCategories() {
        return new LinkedList<RecipeCategory>(this.categories);
    }

    @Override
    public Optional<ButtonAreaSupplier> getSpeedCraftButtonArea(RecipeCategory category) {
        if (!this.speedCraftAreaSupplierMap.containsKey(category.getLocation())) {
            return Optional.of(bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.speedCraftAreaSupplierMap.get(category.getLocation()));
    }

    @Override
    public void registerSpeedCraftButtonArea(ResourceLocation category, ButtonAreaSupplier rectangle) {
        this.speedCraftAreaSupplierMap.put(category, rectangle);
    }

    @Override
    public List<SpeedCraftFunctional> getSpeedCraftFunctional(RecipeCategory category) {
        if (this.speedCraftFunctionalMap.get(category.getLocation()) == null) {
            return Lists.newArrayList();
        }
        return this.speedCraftFunctionalMap.get(category.getLocation());
    }

    @Override
    public void registerSpeedCraftFunctional(ResourceLocation category, SpeedCraftFunctional functional) {
        LinkedList list = this.speedCraftFunctionalMap.containsKey(category) ? new LinkedList(this.speedCraftFunctionalMap.get(category)) : Lists.newLinkedList();
        list.add(functional);
        this.speedCraftFunctionalMap.put(category, list);
    }

    public void recipesLoaded(RecipeManager recipeManager) {
        this.recipeCount.set(0);
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.speedCraftAreaSupplierMap.clear();
        this.speedCraftFunctionalMap.clear();
        LinkedList<REIPlugin> plugins = new LinkedList<REIPlugin>(RoughlyEnoughItemsPlugin.getPlugins());
        plugins.sort((first, second) -> second.getPriority() - first.getPriority());
        RoughlyEnoughItemsCore.LOGGER.info("Loading %d REI plugins: %s", (Object)plugins.size(), (Object)String.join((CharSequence)", ", plugins.stream().map(plugin -> RoughlyEnoughItemsPlugin.getPluginLocation(plugin).map(ResourceLocation::toString).orElseGet(() -> "null")).collect(Collectors.toList())));
        Collections.reverse(plugins);
        RoughlyEnoughItemsCore.getItemRegistry().getModifiableItemList().clear();
        PluginDisabler pluginDisabler = RoughlyEnoughItemsCore.getPluginDisabler();
        plugins.forEach(plugin -> {
            ResourceLocation location = RoughlyEnoughItemsPlugin.getPluginLocation(plugin).orElseGet(() -> new ResourceLocation("null"));
            if (pluginDisabler.isFunctionEnabled(location, PluginFunction.REGISTER_ITEMS)) {
                plugin.registerItems(RoughlyEnoughItemsCore.getItemRegistry());
            }
            if (pluginDisabler.isFunctionEnabled(location, PluginFunction.REGISTER_CATEGORIES)) {
                plugin.registerPluginCategories(this);
            }
            if (pluginDisabler.isFunctionEnabled(location, PluginFunction.REGISTER_RECIPE_DISPLAYS)) {
                plugin.registerRecipeDisplays(this);
            }
            if (pluginDisabler.isFunctionEnabled(location, PluginFunction.REGISTER_SPEED_CRAFT)) {
                plugin.registerSpeedCraft(this);
            }
        });
        RoughlyEnoughItemsCore.LOGGER.info("Registered REI Categories: " + String.join((CharSequence)", ", this.categories.stream().map(RecipeCategory::getCategoryName).collect(Collectors.toList())));
        RoughlyEnoughItemsCore.LOGGER.info("Registered %d recipes for REI.", (Object)this.recipeCount.get());
    }

    @Override
    public int getRecipeCount() {
        return this.recipeCount.get();
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getAllRecipes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        LinkedHashMap tempMap = Maps.newLinkedHashMap();
        this.recipeCategoryListMap.forEach((identifier, recipeDisplays) -> {
            List cfr_ignored_0 = tempMap.put(identifier, new LinkedList(recipeDisplays));
        });
        this.categories.forEach(category -> {
            if (tempMap.containsKey(category.getLocation())) {
                map.put(category, tempMap.get(category.getLocation()));
            }
        });
        return map;
    }
}

