/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.KeyBindHelper;
import me.shedaniel.rei.client.Weather;
import me.shedaniel.rei.gui.RecipeViewingGui;
import me.shedaniel.rei.gui.credits.CreditsGui;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.CraftableToggleButtonWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.GuiEventHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;

public class ContainerGuiOverlay
extends GuiEventHandler {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    public static String searchTerm = "";
    private static int page = 0;
    private static ItemListOverlay itemListOverlay;
    private final List<IWidget> widgets = Lists.newArrayList();
    private Rectangle rectangle;
    private MainWindow window;
    private ButtonWidget buttonLeft;
    private ButtonWidget buttonRight;
    private int lastLeft;

    public void init() {
        this.init(false);
    }

    public void init(boolean setPage) {
        this.widgets.clear();
        this.window = Minecraft.func_71410_x().field_195558_d;
        this.rectangle = this.calculateBoundary();
        this.lastLeft = this.getLeft();
        itemListOverlay = new ItemListOverlay(page);
        this.widgets.add(itemListOverlay);
        itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
        this.buttonLeft = new ButtonWidget(this.rectangle.x, this.rectangle.y + 5, 16, 16, (ITextComponent)new TextComponentTranslation("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                page--;
                if (page < 0) {
                    page = ContainerGuiOverlay.this.getTotalPage();
                }
                itemListOverlay.updateList(ContainerGuiOverlay.this.getItemListArea(), page, searchTerm);
            }
        };
        this.widgets.add(this.buttonLeft);
        this.buttonRight = new ButtonWidget(this.rectangle.x + this.rectangle.width - 18, this.rectangle.y + 5, 16, 16, (ITextComponent)new TextComponentTranslation("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                page++;
                if (page > ContainerGuiOverlay.this.getTotalPage()) {
                    page = 0;
                }
                itemListOverlay.updateList(ContainerGuiOverlay.this.getItemListArea(), page, searchTerm);
            }
        };
        this.widgets.add(this.buttonRight);
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.func_198107_o() - 30 : 10, 10, 20, 20, ""){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                if (GuiScreen.func_146272_n()) {
                    ClientHelper.setCheating(!ClientHelper.isCheating());
                    return;
                }
                ClientHelper.openConfigWindow((GuiScreen)GuiHelper.getLastGuiContainer());
            }

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                super.draw(mouseX, mouseY, partialTicks);
                RenderHelper.func_74518_a();
                if (ClientHelper.isCheating()) {
                    3.func_73734_a((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + 20), (int)(this.getBounds().y + 20), (int)new Color(255, 0, 0, 42).getRGB());
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.getBounds().x + 3, this.getBounds().y + 3, 0, 0, 14, 14);
                if (this.isHighlighted(mouseX, mouseY)) {
                    LinkedList<String> list = new LinkedList<String>(Arrays.asList(I18n.func_135052_a((String)"text.rei.config_tooltip", (Object[])new Object[0]).split("\n")));
                    list.add(" ");
                    if (!ClientHelper.isCheating()) {
                        list.add("\u00a7c\u00a7m" + I18n.func_135052_a((String)"text.rei.cheating", (Object[])new Object[0]));
                    } else {
                        list.add("\u00a7a" + I18n.func_135052_a((String)"text.rei.cheating", (Object[])new Object[0]));
                    }
                    ContainerGuiOverlay.this.addTooltip(QueuedTooltip.create(list));
                }
            }
        });
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().disableCreditsButton) {
            this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.func_198107_o() - 50 : 10, this.window.func_198087_p() - 30, 40, 20, I18n.func_135052_a((String)"text.rei.credits", (Object[])new Object[0])){

                @Override
                public void onPressed(int button, double mouseX, double mouseY) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new CreditsGui(GuiHelper.getLastGuiContainer()));
                }
            });
        }
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().showUtilsButtons) {
            this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.func_198107_o() - 55 : 35, 10, 20, 20, ""){

                @Override
                public void onPressed(int button, double mouseX, double mouseY) {
                    Minecraft.func_71410_x().field_71439_g.func_71165_d(RoughlyEnoughItemsCore.getConfigManager().getConfig().gamemodeCommand.replaceAll("\\{gamemode}", ContainerGuiOverlay.this.getNextGameMode().func_77149_b()));
                }

                @Override
                public void draw(int mouseX, int mouseY, float partialTicks) {
                    this.text = ContainerGuiOverlay.this.getGameModeShortText(ContainerGuiOverlay.this.getCurrentGameMode());
                    super.draw(mouseX, mouseY, partialTicks);
                    if (this.isHighlighted(mouseX, mouseY)) {
                        List<String> list = Arrays.asList(I18n.func_135052_a((String)"text.rei.gamemode_button.tooltip", (Object[])new Object[]{ContainerGuiOverlay.this.getGameModeText(ContainerGuiOverlay.this.getNextGameMode())}).split("\n"));
                        ContainerGuiOverlay.this.addTooltip(QueuedTooltip.create(list));
                    }
                }
            });
            this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.func_198107_o() - 80 : 60, 10, 20, 20, ""){

                @Override
                public void onPressed(int button, double mouseX, double mouseY) {
                    Minecraft.func_71410_x().field_71439_g.func_71165_d(RoughlyEnoughItemsCore.getConfigManager().getConfig().weatherCommand.replaceAll("\\{weather}", ContainerGuiOverlay.this.getNextWeather().getName().toLowerCase()));
                }

                @Override
                public void draw(int mouseX, int mouseY, float partialTicks) {
                    super.draw(mouseX, mouseY, partialTicks);
                    RenderHelper.func_74518_a();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(this.getBounds().x + 3, this.getBounds().y + 3, ContainerGuiOverlay.this.getCurrentWeather().getId() * 14, 14, 14, 14);
                    if (this.isHighlighted(mouseX, mouseY)) {
                        List<String> list = Arrays.asList(I18n.func_135052_a((String)"text.rei.weather_button.tooltip", (Object[])new Object[]{ContainerGuiOverlay.this.getNextWeather().getName()}).split("\n"));
                        ContainerGuiOverlay.this.addTooltip(QueuedTooltip.create(list));
                    }
                }
            });
        }
        this.widgets.add(new ClickableLabelWidget(this.rectangle.x + this.rectangle.width / 2, this.rectangle.y + 10, ""){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                page = MathHelper.func_76125_a((int)page, (int)0, (int)ContainerGuiOverlay.this.getTotalPage());
                this.text = String.format("%s/%s", page + 1, ContainerGuiOverlay.this.getTotalPage() + 1);
                super.draw(mouseX, mouseY, partialTicks);
                if (this.isHighlighted(mouseX, mouseY)) {
                    ContainerGuiOverlay.this.addTooltip(QueuedTooltip.create(Arrays.asList(I18n.func_135052_a((String)"text.rei.go_back_first_page", (Object[])new Object[0]).split("\n"))));
                }
            }

            @Override
            public void onLabelClicked() {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                page = 0;
                itemListOverlay.updateList(ContainerGuiOverlay.this.getItemListArea(), page, searchTerm);
            }
        });
        if (GuiHelper.searchField == null) {
            GuiHelper.searchField = new TextFieldWidget(0, 0, 0, 0){

                @Override
                public boolean mouseClicked(double double_1, double double_2, int int_1) {
                    if (this.isVisible() && this.getBounds().contains(double_1, double_2) && int_1 == 1) {
                        this.setText("");
                        return true;
                    }
                    return super.mouseClicked(double_1, double_2, int_1);
                }
            };
        }
        GuiHelper.searchField.setChangedListener(s -> {
            searchTerm = s;
            itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
        });
        GuiHelper.searchField.getBounds().setBounds(this.getTextFieldArea());
        this.widgets.add(GuiHelper.searchField);
        GuiHelper.searchField.setText(searchTerm);
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton) {
            this.widgets.add(new CraftableToggleButtonWidget(this.getCraftableToggleArea()){

                @Override
                public void onPressed(int button, double mouseX, double mouseY) {
                    RoughlyEnoughItemsCore.getConfigManager().toggleCraftableOnly();
                    itemListOverlay.updateList(ContainerGuiOverlay.this.getItemListArea(), page, searchTerm);
                }
            });
        }
        if (setPage) {
            page = MathHelper.func_76125_a((int)page, (int)0, (int)this.getTotalPage());
        }
        itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.func_72911_I()) {
            return Weather.THUNDER;
        }
        if (world.func_72912_H().func_76059_o()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(GameType gameMode) {
        switch (gameMode) {
            case CREATIVE: {
                return "C";
            }
            case SURVIVAL: {
                return "S";
            }
            case ADVENTURE: {
                return "A";
            }
            case SPECTATOR: {
                return "SP";
            }
        }
        return gameMode.name();
    }

    private String getGameModeText(GameType gameMode) {
        switch (gameMode) {
            case CREATIVE: {
                return "Creative";
            }
            case SURVIVAL: {
                return "Survival";
            }
            case ADVENTURE: {
                return "Adventure";
            }
            case SPECTATOR: {
                return "Spectator";
            }
        }
        return gameMode.name();
    }

    private GameType getNextGameMode() {
        try {
            GameType current = this.getCurrentGameMode();
            int next = current.func_77148_a() + 1;
            if (next >= 3) {
                next = 0;
            }
            return GameType.func_77146_a((int)next);
        }
        catch (Exception e) {
            return GameType.NOT_SET;
        }
    }

    private GameType getCurrentGameMode() {
        return Minecraft.func_71410_x().func_147114_u().func_175102_a(Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId()).func_178848_b();
    }

    private Rectangle getTextFieldArea() {
        int widthRemoved;
        int n = widthRemoved = RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton ? 22 : 2;
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().sideSearchField) {
            return new Rectangle(this.rectangle.x + 2, this.window.func_198087_p() - 22, this.rectangle.width - 6 - widthRemoved, 18);
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof RecipeViewingGui) {
            RecipeViewingGui widget = (RecipeViewingGui)Minecraft.func_71410_x().field_71462_r;
            return new Rectangle(widget.getBounds().x, this.window.func_198087_p() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        return new Rectangle(GuiHelper.getLastGuiContainer().getGuiLeft(), this.window.func_198087_p() - 22, GuiHelper.getLastGuiContainer().getXSize() - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle searchBoxArea = this.getTextFieldArea();
        searchBoxArea.setLocation(searchBoxArea.x + searchBoxArea.width + 4, searchBoxArea.y - 1);
        searchBoxArea.setSize(20, 20);
        return searchBoxArea;
    }

    private String getCheatModeText() {
        return I18n.func_135052_a((String)String.format("%s%s", "text.rei.", ClientHelper.isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    private Rectangle getItemListArea() {
        return new Rectangle(this.rectangle.x + 2, this.rectangle.y + 24, this.rectangle.width - 4, this.rectangle.height - (RoughlyEnoughItemsCore.getConfigManager().getConfig().sideSearchField ? 49 : 27));
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void renderOverlay(int mouseX, int mouseY, float partialTicks) {
        List<ItemStack> currentStacks = ClientHelper.getInventoryItemsTypes();
        if (this.getLeft() != this.lastLeft) {
            this.init(true);
        } else if (RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() && (!this.hasSameListContent(new LinkedList<ItemStack>(GuiHelper.inventoryStacks), currentStacks) || currentStacks.size() != GuiHelper.inventoryStacks.size())) {
            GuiHelper.inventoryStacks = ClientHelper.getInventoryItemsTypes();
            itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.render(mouseX, mouseY, partialTicks);
        RenderHelper.func_74518_a();
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (!(currentScreen instanceof RecipeViewingGui) || !((RecipeViewingGui)currentScreen).choosePageActivated) {
            QUEUED_TOOLTIPS.stream().filter(queuedTooltip -> queuedTooltip != null).forEach(queuedTooltip -> Minecraft.func_71410_x().field_71462_r.func_146283_a(queuedTooltip.getText(), queuedTooltip.getLocation().x, queuedTooltip.getLocation().y));
        }
        QUEUED_TOOLTIPS.clear();
        RenderHelper.func_74518_a();
    }

    private boolean hasSameListContent(List<ItemStack> list1, List<ItemStack> list2) {
        Collections.sort(list1, (itemStack, t1) -> ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1)));
        Collections.sort(list2, (itemStack, t1) -> ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1)));
        String lastString = String.join((CharSequence)"", list1.stream().map(itemStack -> ItemListOverlay.tryGetItemStackName(itemStack)).collect(Collectors.toList()));
        String currentString = String.join((CharSequence)"", list2.stream().map(itemStack -> ItemListOverlay.tryGetItemStackName(itemStack)).collect(Collectors.toList()));
        return lastString.equals(currentString);
    }

    public void addTooltip(QueuedTooltip queuedTooltip) {
        QUEUED_TOOLTIPS.add(queuedTooltip);
    }

    public void render(int int_1, int int_2, float float_1) {
        if (!GuiHelper.isOverlayVisible()) {
            return;
        }
        this.widgets.forEach(widget -> {
            RenderHelper.func_74518_a();
            widget.draw(int_1, int_2, float_1);
        });
        RenderHelper.func_74518_a();
    }

    private Rectangle calculateBoundary() {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel) {
            int startX = GuiHelper.getLastGuiContainer().getGuiLeft() + GuiHelper.getLastGuiContainer().getXSize() + 10;
            int width = this.window.func_198107_o() - startX;
            if (Minecraft.func_71410_x().field_71462_r instanceof RecipeViewingGui) {
                RecipeViewingGui widget = (RecipeViewingGui)Minecraft.func_71410_x().field_71462_r;
                startX = widget.getBounds().x + widget.getBounds().width + 10;
                width = this.window.func_198107_o() - startX;
            }
            return new Rectangle(startX, 0, width, this.window.func_198087_p());
        }
        return new Rectangle(4, 0, this.getLeft() - 6, this.window.func_198087_p());
    }

    private int getLeft() {
        if (Minecraft.func_71410_x().field_71462_r instanceof RecipeViewingGui) {
            RecipeViewingGui widget = (RecipeViewingGui)Minecraft.func_71410_x().field_71462_r;
            return widget.getBounds().x;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_199507_B().func_192812_b()) {
            return GuiHelper.getLastGuiContainer().getGuiLeft() - 147 - 30;
        }
        return GuiHelper.getLastGuiContainer().getGuiLeft();
    }

    private int getTotalPage() {
        return MathHelper.func_76123_f((float)(itemListOverlay.getCurrentDisplayed().size() / itemListOverlay.getTotalSlotsPerPage()));
    }

    public boolean mouseScrolled(double amount) {
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        if (this.rectangle.contains(ClientHelper.getMouseLocation())) {
            if (amount > 0.0 && this.buttonLeft.enabled) {
                this.buttonLeft.onPressed(0, 0.0, 0.0);
            } else if (amount < 0.0 && this.buttonRight.enabled) {
                this.buttonRight.onPressed(0, 0.0, 0.0);
            } else {
                return false;
            }
            return true;
        }
        for (IWidget widget : this.widgets) {
            if (!widget.mouseScrolled(amount)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        void var5_8;
        if (GuiHelper.isOverlayVisible()) {
            for (IGuiEventListener iGuiEventListener : this.widgets) {
                if (!iGuiEventListener.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        if (KeyBindHelper.HIDE.func_197976_a(int_1, int_2)) {
            GuiHelper.toggleOverlayVisible();
            return true;
        }
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        Point point = ClientHelper.getMouseLocation();
        Object var5_6 = null;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer && GuiHelper.getLastGuiContainer().getSlotUnderMouse() != null && !GuiHelper.getLastGuiContainer().getSlotUnderMouse().func_75211_c().func_190926_b()) {
            ItemStack itemStack = GuiHelper.getLastGuiContainer().getSlotUnderMouse().func_75211_c();
        }
        if (var5_8 != null && !var5_8.func_190926_b()) {
            if (KeyBindHelper.RECIPE.func_197976_a(int_1, int_2)) {
                return ClientHelper.executeRecipeKeyBind((ItemStack)var5_8);
            }
            if (KeyBindHelper.USAGE.func_197976_a(int_1, int_2)) {
                return ClientHelper.executeUsageKeyBind((ItemStack)var5_8);
            }
        }
        return false;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        for (IGuiEventListener iGuiEventListener : this.widgets) {
            if (!iGuiEventListener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    protected List<? extends IGuiEventListener> func_195074_b() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        return super.mouseClicked(double_1, double_2, int_1);
    }
}

