/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.RecipeChoosePageWidget;
import me.shedaniel.rei.gui.widget.SpeedCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class RecipeViewingGui
extends GuiScreen {
    public static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final Color SUB_COLOR = new Color(159, 159, 159);
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private final List<IWidget> widgets;
    private final List<TabWidget> tabs;
    private final Map<RecipeCategory, List<RecipeDisplay>> categoriesMap;
    private final List<RecipeCategory> categories;
    public int guiWidth;
    public int guiHeight;
    public int largestWidth;
    public int largestHeight;
    public boolean choosePageActivated;
    public RecipeChoosePageWidget recipeChoosePageWidget;
    public int page;
    public int categoryPages = 0;
    private MainWindow window;
    private Rectangle bounds;
    private RecipeCategory selectedCategory;
    private ButtonWidget recipeBack;
    private ButtonWidget recipeNext;
    private ButtonWidget categoryBack;
    private ButtonWidget categoryNext;

    public RecipeViewingGui(MainWindow window, Map<RecipeCategory, List<RecipeDisplay>> categoriesMap) {
        this.window = window;
        this.widgets = Lists.newArrayList();
        this.bounds = new Rectangle(window.func_198107_o() / 2 - this.guiWidth / 2, window.func_198087_p() / 2 - this.guiHeight / 2, this.guiWidth, this.guiHeight);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList();
        RecipeHelper.getInstance().getAllCategories().forEach(category -> {
            if (categoriesMap.containsKey(category)) {
                this.categories.add((RecipeCategory)category);
            }
        });
        this.selectedCategory = this.categories.get(0);
        this.tabs = new ArrayList<TabWidget>();
        this.choosePageActivated = false;
    }

    public static SpeedCraftFunctional getSpeedCraftFunctionalByCategory(GuiContainer guiContainer, RecipeCategory category) {
        for (SpeedCraftFunctional functional : RecipeHelper.getInstance().getSpeedCraftFunctional(category)) {
            for (Class aClass : functional.getFunctioningFor()) {
                if (!guiContainer.getClass().isAssignableFrom(aClass)) continue;
                return functional;
            }
        }
        return null;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.func_73866_w_();
            return true;
        }
        if ((int_1 == 256 || this.field_146297_k.field_71474_y.field_151445_Q.func_197976_a(int_1, int_2)) && this.func_195120_Y_()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiHelper.getLastGuiContainer());
            GuiHelper.getLastOverlay().init();
            return true;
        }
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.keyPressed(int_1, int_2, int_3);
        }
        for (IGuiEventListener listener : this.field_195124_j) {
            if (!listener.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_195124_j.clear();
        this.tabs.clear();
        this.widgets.clear();
        this.largestWidth = this.window.func_198107_o() - 100;
        this.largestHeight = this.window.func_198087_p() - 40;
        this.guiWidth = MathHelper.func_76125_a((int)(this.getCurrentDisplayed().stream().map(display -> this.selectedCategory.getDisplayWidth(display)).max(Integer::compareTo).orElse(150) + 30), (int)0, (int)this.largestWidth);
        this.guiHeight = MathHelper.func_76128_c((double)MathHelper.func_151237_a((double)(((double)this.selectedCategory.getDisplayHeight() + 7.0) * ((double)this.getRecipesPerPage() + 1.0) + 40.0), (double)186.0, (double)this.largestHeight));
        this.bounds = new Rectangle(this.window.func_198107_o() / 2 - this.guiWidth / 2, this.window.func_198087_p() / 2 - this.guiHeight / 2, this.guiWidth, this.guiHeight);
        this.page = MathHelper.func_76125_a((int)this.page, (int)0, (int)(this.getTotalPages(this.selectedCategory) - 1));
        this.categoryBack = new ButtonWidget((int)this.bounds.getX() + 5, (int)this.bounds.getY() + 5, 12, 12, (ITextComponent)new TextComponentTranslation("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                int currentCategoryIndex = RecipeViewingGui.this.categories.indexOf(RecipeViewingGui.this.selectedCategory);
                if (--currentCategoryIndex < 0) {
                    currentCategoryIndex = RecipeViewingGui.this.categories.size() - 1;
                }
                RecipeViewingGui.this.selectedCategory = (RecipeCategory)RecipeViewingGui.this.categories.get(currentCategoryIndex);
                RecipeViewingGui.this.categoryPages = MathHelper.func_76128_c((double)((double)currentCategoryIndex / 6.0));
                RecipeViewingGui.this.page = 0;
                RecipeViewingGui.this.func_73866_w_();
            }
        };
        this.widgets.add(this.categoryBack);
        this.categoryNext = new ButtonWidget((int)this.bounds.getMaxX() - 17, (int)this.bounds.getY() + 5, 12, 12, (ITextComponent)new TextComponentTranslation("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                int currentCategoryIndex = RecipeViewingGui.this.categories.indexOf(RecipeViewingGui.this.selectedCategory);
                if (++currentCategoryIndex >= RecipeViewingGui.this.categories.size()) {
                    currentCategoryIndex = 0;
                }
                RecipeViewingGui.this.selectedCategory = (RecipeCategory)RecipeViewingGui.this.categories.get(currentCategoryIndex);
                RecipeViewingGui.this.categoryPages = MathHelper.func_76128_c((double)((double)currentCategoryIndex / 6.0));
                RecipeViewingGui.this.page = 0;
                RecipeViewingGui.this.func_73866_w_();
            }
        };
        this.widgets.add(this.categoryNext);
        this.categoryBack.enabled = this.categories.size() > 1;
        this.categoryNext.enabled = this.categories.size() > 1;
        this.recipeBack = new ButtonWidget((int)this.bounds.getX() + 5, (int)this.bounds.getY() + 21, 12, 12, (ITextComponent)new TextComponentTranslation("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                --RecipeViewingGui.this.page;
                if (RecipeViewingGui.this.page < 0) {
                    RecipeViewingGui.this.page = RecipeViewingGui.this.getTotalPages(RecipeViewingGui.this.selectedCategory) - 1;
                }
                RecipeViewingGui.this.func_73866_w_();
            }
        };
        this.widgets.add(this.recipeBack);
        this.recipeNext = new ButtonWidget((int)this.bounds.getMaxX() - 17, (int)this.bounds.getY() + 21, 12, 12, (ITextComponent)new TextComponentTranslation("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                ++RecipeViewingGui.this.page;
                if (RecipeViewingGui.this.page >= RecipeViewingGui.this.getTotalPages(RecipeViewingGui.this.selectedCategory)) {
                    RecipeViewingGui.this.page = 0;
                }
                RecipeViewingGui.this.func_73866_w_();
            }
        };
        this.widgets.add(this.recipeNext);
        this.recipeBack.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPage();
        this.recipeNext.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPage();
        this.widgets.add(new ClickableLabelWidget((int)this.bounds.getCenterX(), (int)this.bounds.getY() + 7, ""){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                this.text = RecipeViewingGui.this.selectedCategory.getCategoryName();
                super.draw(mouseX, mouseY, partialTicks);
                if (this.isHighlighted(mouseX, mouseY)) {
                    GuiHelper.getLastOverlay().addTooltip(QueuedTooltip.create(I18n.func_135052_a((String)"text.rei.view_all_categories", (Object[])new Object[0]).split("\n")));
                }
            }

            @Override
            public void onLabelClicked() {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                ClientHelper.executeViewAllRecipesKeyBind();
            }
        });
        this.widgets.add(new ClickableLabelWidget((int)this.bounds.getCenterX(), (int)this.bounds.getY() + 23, ""){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                this.text = String.format("%d/%d", RecipeViewingGui.this.page + 1, RecipeViewingGui.this.getTotalPages(RecipeViewingGui.this.selectedCategory));
                super.draw(mouseX, mouseY, partialTicks);
                if (this.isHighlighted(mouseX, mouseY)) {
                    GuiHelper.getLastOverlay().addTooltip(QueuedTooltip.create(I18n.func_135052_a((String)"text.rei.choose_page", (Object[])new Object[0]).split("\n")));
                }
            }

            @Override
            public void onLabelClicked() {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                RecipeViewingGui.this.choosePageActivated = true;
                RecipeViewingGui.this.func_73866_w_();
            }
        });
        for (int i = 0; i < 6; ++i) {
            int j = i + this.categoryPages * 6;
            if (this.categories.size() <= j) continue;
            TabWidget tab = new TabWidget(i, this, new Rectangle(this.bounds.x + 4 + 28 * i, this.bounds.y - 28, 28, 28)){

                @Override
                public boolean onMouseClick(int button, double mouseX, double mouseY) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                        if (this.getId() + RecipeViewingGui.this.categoryPages * 6 == RecipeViewingGui.this.categories.indexOf(RecipeViewingGui.this.selectedCategory)) {
                            return false;
                        }
                        RecipeViewingGui.this.selectedCategory = (RecipeCategory)RecipeViewingGui.this.categories.get(this.getId() + RecipeViewingGui.this.categoryPages * 6);
                        RecipeViewingGui.this.page = 0;
                        RecipeViewingGui.this.func_73866_w_();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setItem(this.categories.get(j).getCategoryIcon(), this.categories.get(j).getCategoryName(), tab.getId() + this.categoryPages * 6 == this.categories.indexOf(this.selectedCategory));
        }
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getSpeedCraftButtonArea(this.selectedCategory);
        SpeedCraftFunctional functional = RecipeViewingGui.getSpeedCraftFunctionalByCategory(GuiHelper.getLastGuiContainer(), this.selectedCategory);
        int recipeHeight = this.selectedCategory.getDisplayHeight();
        List<RecipeDisplay> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            int finalI = i;
            Supplier<RecipeDisplay> displaySupplier = () -> (RecipeDisplay)currentDisplayed.get(finalI);
            int displayWidth = this.selectedCategory.getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle((int)this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().y + 40 + recipeHeight * i + 7 * i, displayWidth, recipeHeight);
            this.widgets.addAll(this.selectedCategory.setupDisplay(displaySupplier, displayBounds));
            if (!supplier.isPresent()) continue;
            this.widgets.add(new SpeedCraftingButtonWidget(supplier.get().get(displayBounds), supplier.get().getButtonText(), functional, displaySupplier));
        }
        this.recipeChoosePageWidget = this.choosePageActivated ? new RecipeChoosePageWidget(this, this.page, this.getTotalPages(this.selectedCategory)) : null;
        this.field_195124_j.addAll(this.tabs);
        this.field_195124_j.add(GuiHelper.getLastOverlay(true, false));
        this.field_195124_j.addAll(this.widgets);
    }

    public List<IWidget> getWidgets() {
        return this.widgets;
    }

    public List<RecipeDisplay> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= this.categoriesMap.get(this.selectedCategory).size()) continue;
            list.add(this.categoriesMap.get(this.selectedCategory).get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    private int getRecipesPerPage() {
        if (this.selectedCategory.getDisplaySettings().getFixedRecipesPerPage() > 0) {
            return this.selectedCategory.getDisplaySettings().getFixedRecipesPerPage() - 1;
        }
        int height = this.selectedCategory.getDisplayHeight();
        return MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)(((double)this.largestHeight - 40.0) / ((double)height + 7.0))) - 1), (int)0, (int)Math.min(RoughlyEnoughItemsCore.getConfigManager().getConfig().maxRecipePerPage - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    private int getRecipesPerPageByHeight() {
        int height = this.selectedCategory.getDisplayHeight();
        return MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)(((double)this.guiHeight - 40.0) / ((double)height + 7.0))) - 1), (int)0, (int)Math.min(RoughlyEnoughItemsCore.getConfigManager().getConfig().maxRecipePerPage - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        if (this.selectedCategory != null) {
            this.selectedCategory.drawCategoryBackground(this.bounds, mouseX, mouseY, partialTicks);
        } else {
            new RecipeBaseWidget(this.bounds).draw(mouseX, mouseY, partialTicks);
            RecipeViewingGui.func_73734_a((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)SUB_COLOR.getRGB());
            RecipeViewingGui.func_73734_a((int)(this.bounds.x + 17), (int)(this.bounds.y + 21), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 33), (int)SUB_COLOR.getRGB());
        }
        this.tabs.stream().filter(tabWidget -> !tabWidget.isSelected()).forEach(tabWidget -> tabWidget.draw(mouseX, mouseY, partialTicks));
        RenderHelper.func_74518_a();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.widgets.forEach(widget -> {
            RenderHelper.func_74518_a();
            widget.draw(mouseX, mouseY, partialTicks);
        });
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.tabs.stream().filter(TabWidget::isSelected).forEach(tabWidget -> tabWidget.draw(mouseX, mouseY, partialTicks));
        GuiHelper.getLastOverlay().renderOverlay(mouseX, mouseY, partialTicks);
        if (this.choosePageActivated) {
            this.field_73735_i = 500.0f;
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
            this.field_73735_i = 0.0f;
            this.recipeChoosePageWidget.draw(mouseX, mouseY, partialTicks);
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    public int getTotalPages(RecipeCategory category) {
        return MathHelper.func_76143_f((double)((double)this.categoriesMap.get(category).size() / ((double)this.getRecipesPerPage() + 1.0)));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.charTyped(char_1, int_1);
        }
        for (IGuiEventListener listener : this.field_195124_j) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }
        return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseReleased(double_1, double_2, int_1);
        }
        return super.mouseReleased(double_1, double_2, int_1);
    }

    public boolean mouseScrolled(double amount) {
        for (IGuiEventListener listener : this.field_195124_j) {
            if (!listener.mouseScrolled(amount)) continue;
            return true;
        }
        if (this.getBounds().contains(ClientHelper.getMouseLocation())) {
            if (amount > 0.0 && this.recipeBack.enabled) {
                this.recipeBack.onPressed(0, 0.0, 0.0);
            } else if (amount < 0.0 && this.recipeNext.enabled) {
                this.recipeNext.onPressed(0, 0.0, 0.0);
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(ClientHelper.getMouseLocation())) {
            if (amount > 0.0 && this.categoryBack.enabled) {
                this.categoryBack.onPressed(0, 0.0, 0.0);
            } else if (amount < 0.0 && this.categoryNext.enabled) {
                this.categoryNext.onPressed(0, 0.0, 0.0);
            }
        }
        return super.mouseScrolled(amount);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            if (this.recipeChoosePageWidget.isHighlighted(double_1, double_2)) {
                return this.recipeChoosePageWidget.mouseClicked(double_1, double_2, int_1);
            }
            this.choosePageActivated = false;
            this.func_73866_w_();
            return false;
        }
        for (IGuiEventListener entry : this.func_195074_b()) {
            if (!entry.mouseClicked(double_1, double_2, int_1)) continue;
            this.func_205725_b(entry);
            if (int_1 == 0) {
                this.func_195072_d(true);
            }
            return true;
        }
        return false;
    }

    public RecipeCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public IGuiEventListener getFocused() {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget;
        }
        return super.getFocused();
    }
}

