/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.config;

import java.awt.Point;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;

public abstract class ConfigEntry
extends GuiListExtended.IGuiListEntry<ConfigEntry> {

    public static class TextFieldConfigEntry
    extends ConfigEntry {
        private ITextComponent nameComponent;
        private ConfigEntryTextFieldProvider textFieldProvider;
        private TextFieldWidget textFieldWidget;

        public TextFieldConfigEntry(ITextComponent nameComponent, ConfigEntryTextFieldProvider textFieldProvider) {
            this.nameComponent = nameComponent;
            this.textFieldProvider = textFieldProvider;
            this.textFieldWidget = new TextFieldWidget(0, 0, 148, 18);
            this.textFieldWidget.setChangedListener(s -> textFieldProvider.onUpdateText(this.textFieldWidget, (String)s));
            this.textFieldProvider.onInitWidget(this.textFieldWidget);
        }

        public void func_194999_a(int entryWidth, int height, int i3, int i4, boolean isSelected, float delta) {
            MainWindow window = Minecraft.func_71410_x().field_195558_d;
            Point mouse = ClientHelper.getMouseLocation();
            if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(this.nameComponent.func_150254_d(), (float)(window.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.nameComponent.func_150254_d()) - 40), (float)(this.func_195001_c() + 5), 0xFFFFFF);
                this.textFieldWidget.getBounds().setLocation(this.func_195002_d() + 1, this.func_195001_c() + 2);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(this.nameComponent.func_150254_d(), (float)this.func_195002_d(), (float)(this.func_195001_c() + 5), 0xFFFFFF);
                this.textFieldWidget.getBounds().setLocation(window.func_198107_o() - 190 + 1, this.func_195001_c() + 2);
            }
            this.textFieldProvider.draw(this.textFieldWidget, mouse, delta);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            return this.textFieldWidget.mouseClicked(double_1, double_2, int_1);
        }

        public boolean charTyped(char char_1, int int_1) {
            return this.textFieldWidget.charTyped(char_1, int_1);
        }

        public boolean keyPressed(int int_1, int int_2, int int_3) {
            return this.textFieldWidget.keyPressed(int_1, int_2, int_3);
        }

        static interface ConfigEntryTextFieldProvider {
            public void onInitWidget(TextFieldWidget var1);

            public void onUpdateText(TextFieldWidget var1, String var2);

            default public void draw(TextFieldWidget widget, Point mouse, float delta) {
                widget.draw(mouse.x, mouse.y, delta);
            }
        }
    }

    public static class CategoryTitleConfigEntry
    extends ConfigEntry {
        private ITextComponent textComponent;

        public CategoryTitleConfigEntry(ITextComponent nameComponent) {
            this.textComponent = nameComponent.func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)));
        }

        public void func_194999_a(int i, int i1, int i2, int i3, boolean b, float v) {
            MainWindow window = Minecraft.func_71410_x().field_195558_d;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_211126_b(this.textComponent.func_150254_d(), (float)((window.func_198107_o() - fontRenderer.func_78256_a(this.textComponent.func_150254_d())) / 2), (float)(this.func_195001_c() + 10), -1);
        }
    }

    public static class ButtonConfigEntry
    extends ConfigEntry {
        private ITextComponent nameComponent;
        private ConfigEntryButtonProvider buttonProvider;
        private ButtonWidget buttonWidget;

        public ButtonConfigEntry(ITextComponent nameComponent, final ConfigEntryButtonProvider buttonProvider) {
            this.nameComponent = nameComponent;
            this.buttonProvider = buttonProvider;
            this.buttonWidget = new ButtonWidget(0, 0, 150, 20, ""){

                @Override
                public boolean onMouseClick(int button, double mouseX, double mouseY) {
                    if (this.getBounds().contains(mouseX, mouseY) && this.enabled && buttonProvider.onPressed(button, mouseX, mouseY)) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                        return true;
                    }
                    return false;
                }

                @Override
                public void onPressed(int button, double mouseX, double mouseY) {
                }
            };
        }

        public void func_194999_a(int entryWidth, int height, int i3, int i4, boolean isSelected, float delta) {
            MainWindow window = Minecraft.func_71410_x().field_195558_d;
            Point mouse = ClientHelper.getMouseLocation();
            if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(this.nameComponent.func_150254_d(), (float)(window.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.nameComponent.func_150254_d()) - 40), (float)(this.func_195001_c() + 5), 0xFFFFFF);
                this.buttonWidget.text = this.buttonProvider.getText();
                this.buttonWidget.getBounds().setLocation(this.func_195002_d(), this.func_195001_c() + 2);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(this.nameComponent.func_150254_d(), (float)this.func_195002_d(), (float)(this.func_195001_c() + 5), 0xFFFFFF);
                this.buttonWidget.text = this.buttonProvider.getText();
                this.buttonWidget.getBounds().setLocation(window.func_198107_o() - 190, this.func_195001_c() + 2);
            }
            this.buttonProvider.draw(this.buttonWidget, mouse, delta);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            return this.buttonWidget.mouseClicked(double_1, double_2, int_1);
        }

        static interface ConfigEntryButtonProvider {
            public boolean onPressed(int var1, double var2, double var4);

            public String getText();

            default public void draw(ButtonWidget button, Point mouse, float delta) {
                button.draw(mouse.x, mouse.y, delta);
            }
        }
    }
}

