/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.config;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.ItemListOrdering;
import me.shedaniel.rei.gui.config.ConfigEntry;
import me.shedaniel.rei.gui.config.ConfigEntryListWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ConfigGui
extends GuiScreen {
    private final List<QueuedTooltip> tooltipList = Lists.newArrayList();
    private GuiScreen parent;
    private ConfigEntryListWidget entryListWidget;

    public ConfigGui(GuiScreen parent) {
        this.parent = parent;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.func_195120_Y_()) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
            GuiHelper.getLastOverlay().init();
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    protected void func_73866_w_() {
        this.entryListWidget = new ConfigEntryListWidget(this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 32, 24);
        this.field_195124_j.add(this.entryListWidget);
        this.entryListWidget.configClearEntries();
        this.entryListWidget.configAddEntry(new ConfigEntry.CategoryTitleConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.general", new Object[0])));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.cheating", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    ClientHelper.setCheating(!ClientHelper.isCheating());
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(ClientHelper.isCheating());
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.CategoryTitleConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.appearance", new Object[0])));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.side_search_box", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().sideSearchField = !RoughlyEnoughItemsCore.getConfigManager().getConfig().sideSearchField;
                }
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(RoughlyEnoughItemsCore.getConfigManager().getConfig().sideSearchField);
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.list_ordering", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                int index = Arrays.asList(ItemListOrdering.values()).indexOf((Object)RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering) + 1;
                if (index >= ItemListOrdering.values().length) {
                    index = 0;
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending = !RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending;
                }
                RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering = ItemListOrdering.values()[index];
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return I18n.func_135052_a((String)"text.rei.config.list_ordering_button", (Object[])new Object[]{I18n.func_135052_a((String)RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.getNameTranslationKey(), (Object[])new Object[0]), I18n.func_135052_a((String)(RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending ? "ordering.rei.ascending" : "ordering.rei.descending"), (Object[])new Object[0])});
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.mirror_rei", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel = !RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel;
                }
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel);
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.CategoryTitleConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.modules", new Object[0])));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.enable_craftable_only", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton = !RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton;
                }
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton);
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.load_default_plugin", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().loadDefaultPlugin = !RoughlyEnoughItemsCore.getConfigManager().getConfig().loadDefaultPlugin;
                }
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(RoughlyEnoughItemsCore.getConfigManager().getConfig().loadDefaultPlugin);
            }

            @Override
            public void draw(ButtonWidget button, Point mouse, float delta) {
                button.draw(mouse.x, mouse.y, delta);
                if (button.isHighlighted(mouse)) {
                    RenderHelper.func_74518_a();
                    ConfigGui.this.tooltipList.add(QueuedTooltip.create(I18n.func_135052_a((String)"text.rei.config.load_default_plugin.restart_tooltip", (Object[])new Object[0]).split("\n")));
                    RenderHelper.func_74518_a();
                }
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.disable_credits_button", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().disableCreditsButton = !RoughlyEnoughItemsCore.getConfigManager().getConfig().disableCreditsButton;
                }
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(RoughlyEnoughItemsCore.getConfigManager().getConfig().disableCreditsButton);
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.ButtonConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.enable_util_buttons", new Object[0]), new ConfigEntry.ButtonConfigEntry.ConfigEntryButtonProvider(){

            @Override
            public boolean onPressed(int button, double mouseX, double mouseY) {
                if (button == 0) {
                    RoughlyEnoughItemsCore.getConfigManager().getConfig().showUtilsButtons = !RoughlyEnoughItemsCore.getConfigManager().getConfig().showUtilsButtons;
                }
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }

            @Override
            public String getText() {
                return ConfigGui.this.getTrueFalseText(RoughlyEnoughItemsCore.getConfigManager().getConfig().showUtilsButtons);
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.CategoryTitleConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.advanced", new Object[0])));
        this.entryListWidget.configAddEntry(new ConfigEntry.TextFieldConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.give_command", new Object[0]), new ConfigEntry.TextFieldConfigEntry.ConfigEntryTextFieldProvider(){

            @Override
            public void onInitWidget(TextFieldWidget widget) {
                widget.setMaxLength(99999);
                widget.setText(RoughlyEnoughItemsCore.getConfigManager().getConfig().giveCommand);
                widget.setSuggestion(I18n.func_135052_a((String)"text.rei.give_command.suggestion", (Object[])new Object[0]));
            }

            @Override
            public void onUpdateText(TextFieldWidget button, String text) {
                RoughlyEnoughItemsCore.getConfigManager().getConfig().giveCommand = text;
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void draw(TextFieldWidget widget, Point mouse, float delta) {
                widget.draw(mouse.x, mouse.y, delta);
                if (widget.isHighlighted(mouse)) {
                    RenderHelper.func_74518_a();
                    ConfigGui.this.tooltipList.add(QueuedTooltip.create(I18n.func_135052_a((String)"text.rei.give_command.tooltip", (Object[])new Object[0]).split("\n")));
                    RenderHelper.func_74518_a();
                }
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.TextFieldConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.gamemode_command", new Object[0]), new ConfigEntry.TextFieldConfigEntry.ConfigEntryTextFieldProvider(){

            @Override
            public void onInitWidget(TextFieldWidget widget) {
                widget.setMaxLength(99999);
                widget.setText(RoughlyEnoughItemsCore.getConfigManager().getConfig().gamemodeCommand);
                widget.setSuggestion(I18n.func_135052_a((String)"text.rei.give_command.suggestion", (Object[])new Object[0]));
            }

            @Override
            public void onUpdateText(TextFieldWidget button, String text) {
                RoughlyEnoughItemsCore.getConfigManager().getConfig().gamemodeCommand = text;
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.TextFieldConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.weather_command", new Object[0]), new ConfigEntry.TextFieldConfigEntry.ConfigEntryTextFieldProvider(){

            @Override
            public void onInitWidget(TextFieldWidget widget) {
                widget.setMaxLength(99999);
                widget.setText(RoughlyEnoughItemsCore.getConfigManager().getConfig().weatherCommand);
                widget.setSuggestion(I18n.func_135052_a((String)"text.rei.give_command.suggestion", (Object[])new Object[0]));
            }

            @Override
            public void onUpdateText(TextFieldWidget button, String text) {
                RoughlyEnoughItemsCore.getConfigManager().getConfig().weatherCommand = text;
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.entryListWidget.configAddEntry(new ConfigEntry.TextFieldConfigEntry((ITextComponent)new TextComponentTranslation("text.rei.config.max_recipes_per_page", new Object[0]), new ConfigEntry.TextFieldConfigEntry.ConfigEntryTextFieldProvider(){

            @Override
            public void onInitWidget(TextFieldWidget widget) {
                widget.setMaxLength(2);
                widget.setText(RoughlyEnoughItemsCore.getConfigManager().getConfig().maxRecipePerPage + "");
                widget.stripInvaild = s -> {
                    StringBuilder stringBuilder_1 = new StringBuilder();
                    for (char char_1 : s.toCharArray()) {
                        if (!Character.isDigit(char_1)) continue;
                        stringBuilder_1.append(char_1);
                    }
                    return stringBuilder_1.toString();
                };
            }

            @Override
            public void onUpdateText(TextFieldWidget button, String text) {
                if (this.isInvaildNumber(text)) {
                    try {
                        RoughlyEnoughItemsCore.getConfigManager().getConfig().maxRecipePerPage = Integer.valueOf(text);
                        RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void draw(TextFieldWidget widget, Point mouse, float delta) {
                widget.setEditableColor(this.isInvaildNumber(widget.getText()) ? -1 : Color.RED.getRGB());
                widget.draw(mouse.x, mouse.y, delta);
            }

            private boolean isInvaildNumber(String text) {
                try {
                    int page = Integer.valueOf(text);
                    return page >= 2 && page <= 99;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }));
        this.func_189646_b(new GuiButton(-1, this.field_146294_l / 2 - 100, this.field_146295_m - 26, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            public void func_194829_a(double double_1, double double_2) {
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ConfigGui.this.field_146297_k.func_147108_a(ConfigGui.this.parent);
                GuiHelper.getLastOverlay().init();
            }
        });
        super.func_73866_w_();
    }

    private String getTrueFalseText(boolean showCraftableOnlyButton) {
        return String.format("%s%b", showCraftableOnlyButton ? "\u00a7a" : "\u00a7c", showCraftableOnlyButton);
    }

    public void func_73863_a(int int_1, int int_2, float float_1) {
        this.func_146278_c(0);
        this.entryListWidget.func_148128_a(int_1, int_2, float_1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"text.rei.config", (Object[])new Object[0]), this.field_146294_l / 2, 16, 0xFFFFFF);
        super.func_73863_a(int_1, int_2, float_1);
        RenderHelper.func_74518_a();
        this.tooltipList.forEach(queuedTooltip -> this.func_146283_a(queuedTooltip.getText(), queuedTooltip.getLocation().x, queuedTooltip.getLocation().y));
        this.tooltipList.clear();
        RenderHelper.func_74518_a();
    }

    public boolean func_73868_f() {
        return false;
    }

    public IGuiEventListener getFocused() {
        return this.entryListWidget;
    }
}

