/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public abstract class ButtonWidget
extends Gui
implements HighlightableWidget {
    protected static final ResourceLocation WIDGET_TEX = new ResourceLocation("textures/gui/widgets.png");
    public String text;
    public boolean enabled;
    public boolean visible;
    protected boolean hovered;
    private boolean pressed;
    private Rectangle bounds;

    public ButtonWidget(Rectangle rectangle, ITextComponent text) {
        this(rectangle, text.func_150254_d());
    }

    public ButtonWidget(Rectangle rectangle, String text) {
        this.bounds = rectangle;
        this.enabled = true;
        this.visible = true;
        this.text = text;
    }

    public ButtonWidget(int x, int y, int width, int height, String text) {
        this(new Rectangle(x, y, width, height), text);
    }

    public ButtonWidget(int x, int y, int width, int height, ITextComponent text) {
        this(new Rectangle(x, y, width, height), text);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    protected int getTextureId(boolean boolean_1) {
        int int_1 = 1;
        if (!this.enabled) {
            int_1 = 0;
        } else if (boolean_1) {
            int_1 = 2;
        }
        return int_1;
    }

    @Override
    public List<IWidget> getListeners() {
        return new ArrayList<IWidget>();
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int x = this.bounds.x;
            int y = this.bounds.y;
            int width = this.bounds.width;
            int height = this.bounds.height;
            Minecraft minecraftClient_1 = Minecraft.func_71410_x();
            FontRenderer fontRenderer_1 = minecraftClient_1.field_71466_p;
            minecraftClient_1.func_110434_K().func_110577_a(WIDGET_TEX);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.hovered = this.bounds.contains(mouseX, mouseY);
            int textureOffset = this.getTextureId(this.hovered);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_73729_b(x, y, 0, 46 + textureOffset * 20, 4, 4);
            this.func_73729_b(x + width - 4, y, 196, 46 + textureOffset * 20, 4, 4);
            this.func_73729_b(x, y + height - 4, 0, 62 + textureOffset * 20, 4, 4);
            this.func_73729_b(x + width - 4, y + height - 4, 196, 62 + textureOffset * 20, 4, 4);
            this.func_73729_b(x + 4, y, 4, 46 + textureOffset * 20, width - 8, 4);
            this.func_73729_b(x + 4, y + height - 4, 4, 62 + textureOffset * 20, width - 8, 4);
            for (int i = y + 4; i < y + height - 4; i += 4) {
                this.func_73729_b(x, i, 0, 50 + textureOffset * 20, width / 2, MathHelper.func_76125_a((int)(y + height - 4 - i), (int)0, (int)4));
                this.func_73729_b(x + width / 2, i, 200 - width / 2, 50 + textureOffset * 20, width / 2, MathHelper.func_76125_a((int)(y + height - 4 - i), (int)0, (int)4));
            }
            int colour = 0xE0E0E0;
            if (!this.enabled) {
                colour = 0xA0A0A0;
            } else if (this.hovered) {
                colour = 0xFFFFA0;
            }
            this.func_73732_a(fontRenderer_1, this.text, x + width / 2, y + (height - 8) / 2, colour);
        }
    }

    @Override
    public boolean onMouseClick(int button, double mouseX, double mouseY) {
        if (this.bounds.contains(mouseX, mouseY) && this.enabled) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onPressed(button, mouseX, mouseY);
            return true;
        }
        return false;
    }

    public abstract void onPressed(int var1, double var2, double var4);
}

