/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.ItemListOrdering;
import me.shedaniel.rei.client.SearchArgument;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.ItemSlotWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class ItemListOverlay
extends Gui
implements IWidget {
    private static List<Item> searchBlacklisted = Lists.newArrayList();
    private List<IWidget> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;
    private List<ItemStack> currentDisplayed = Lists.newArrayList();

    public ItemListOverlay(int page) {
        this.page = page;
    }

    public static List<String> tryGetItemStackToolTip(ItemStack itemStack) {
        if (!searchBlacklisted.contains(itemStack.func_77973_b())) {
            try {
                return Minecraft.func_71410_x().field_71462_r.func_191927_a(itemStack);
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.func_77973_b());
            }
        }
        return Collections.singletonList(ItemListOverlay.tryGetItemStackName(itemStack));
    }

    public static String tryGetItemStackName(ItemStack stack) {
        if (!searchBlacklisted.contains(stack.func_77973_b())) {
            try {
                return stack.func_200301_q().func_150254_d();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.func_77973_b());
            }
        }
        try {
            return I18n.func_135052_a((String)("item." + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public int getTotalSlotsPerPage() {
        return this.width * this.height;
    }

    @Override
    public void draw(int int_1, int int_2, float float_1) {
        this.widgets.forEach(widget -> widget.draw(int_1, int_2, float_1));
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.rectangle.contains(ClientHelper.getMouseLocation()) && ClientHelper.isCheating() && !player.field_71071_by.func_70445_o().func_190926_b() && Minecraft.func_71410_x().func_71356_B()) {
            GuiHelper.getLastOverlay().addTooltip(new QueuedTooltip(ClientHelper.getMouseLocation(), Arrays.asList(I18n.func_135052_a((String)"text.rei.delete_items", (Object[])new Object[0]))));
        }
    }

    public void updateList(Rectangle bounds, int page, String searchTerm) {
        int j;
        this.rectangle = bounds;
        this.currentDisplayed = this.processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getItemRegistry().getItemList(), GuiHelper.inventoryStacks);
        this.widgets = Lists.newLinkedList();
        this.page = page;
        this.calculateListSize(this.rectangle);
        double startX = this.rectangle.getCenterX() - (double)(this.width * 9);
        double startY = this.rectangle.getCenterY() - (double)(this.height * 9);
        this.listArea = new Rectangle((int)startX, (int)startY, this.width * 18, this.height * 18);
        for (int i = 0; i < this.getTotalSlotsPerPage() && (j = i + page * this.getTotalSlotsPerPage()) < this.currentDisplayed.size(); ++i) {
            ItemSlotWidget slotWidget = new ItemSlotWidget((int)(startX + (double)(i % this.width * 18)), (int)(startY + (double)(MathHelper.func_76141_d((float)(i / this.width)) * 18)), Collections.singletonList(this.currentDisplayed.get(j)), false, true, true){

                @Override
                protected void drawToolTip(ItemStack itemStack) {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (!ClientHelper.isCheating() || player.field_71071_by.func_70445_o().func_190926_b() || !Minecraft.func_71410_x().func_71356_B()) {
                        super.drawToolTip(itemStack);
                    }
                }

                @Override
                public boolean onMouseClick(int button, double mouseX, double mouseY) {
                    if (this.isHighlighted(mouseX, mouseY)) {
                        if (ClientHelper.isCheating()) {
                            if (this.getCurrentStack() != null && !this.getCurrentStack().func_190926_b()) {
                                ItemStack cheatedStack = this.getCurrentStack().func_77946_l();
                                cheatedStack.func_190920_e(button == 0 ? 1 : (button == 1 ? cheatedStack.func_77976_d() : cheatedStack.func_190916_E()));
                                return ClientHelper.tryCheatingStack(cheatedStack);
                            }
                        } else {
                            if (button == 0) {
                                return ClientHelper.executeRecipeKeyBind(this.getCurrentStack().func_77946_l());
                            }
                            if (button == 1) {
                                return ClientHelper.executeUsageKeyBind(this.getCurrentStack().func_77946_l());
                            }
                        }
                    }
                    return false;
                }
            };
            this.widgets.add(slotWidget);
        }
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        for (IWidget widget : this.widgets) {
            if (!widget.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<ItemStack> processSearchTerm(String searchTerm, List<ItemStack> ol, List<ItemStack> inventoryItems) {
        AbstractList workingItems;
        LinkedList<ItemStack> os = new LinkedList<ItemStack>(ol);
        ArrayList stacks = Lists.newArrayList();
        ArrayList finalStacks = Lists.newArrayList();
        LinkedList<ItemGroup> itemGroups = new LinkedList<ItemGroup>(Arrays.asList(ItemGroup.field_78032_a));
        itemGroups.add(null);
        ItemListOrdering ordering = RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering;
        if (ordering != ItemListOrdering.registry) {
            Collections.sort(os, (itemStack, t1) -> {
                if (ordering.equals((Object)ItemListOrdering.name)) {
                    return ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1));
                }
                if (ordering.equals((Object)ItemListOrdering.item_groups)) {
                    return itemGroups.indexOf(itemStack.func_77973_b().func_77640_w()) - itemGroups.indexOf(t1.func_77973_b().func_77640_w());
                }
                return 0;
            });
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending) {
            Collections.reverse(os);
        }
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            ArrayList arguments = Lists.newArrayList();
            Arrays.stream(StringUtils.split((String)s)).forEachOrdered(s1 -> {
                if (s1.startsWith("@-") || s1.startsWith("-@")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false));
                } else if (s1.startsWith("@")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true));
                } else if (s1.startsWith("#-") || s1.startsWith("-#")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false));
                } else if (s1.startsWith("#")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true));
                } else if (s1.startsWith("-")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false));
                } else {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TEXT, (String)s1, true));
                }
            });
            os.stream().filter(itemStack -> arguments.isEmpty() || this.filterItem((ItemStack)itemStack, arguments)).forEachOrdered(stacks::add);
        });
        if (splitSearchTerm.length == 0) {
            stacks.addAll(os);
        }
        AbstractList abstractList = workingItems = RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() && inventoryItems.size() > 0 ? new ArrayList() : new LinkedList<ItemStack>(ol);
        if (RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled()) {
            RecipeHelper.getInstance().findCraftableByItems(inventoryItems).forEach(workingItems::add);
            workingItems.addAll(inventoryItems);
        }
        AbstractList finalWorkingItems = workingItems;
        finalStacks.addAll(stacks.stream().filter(itemStack -> {
            if (!RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled()) {
                return true;
            }
            for (ItemStack workingItem : finalWorkingItems) {
                if (!itemStack.func_77969_a(workingItem)) continue;
                return true;
            }
            return false;
        }).distinct().collect(Collectors.toList()));
        return finalStacks;
    }

    private boolean filterItem(ItemStack itemStack, List<SearchArgument> arguments) {
        String mod = ClientHelper.getModFromItemStack(itemStack);
        List<String> toolTipsList = ItemListOverlay.tryGetItemStackToolTip(itemStack);
        String toolTipsMixed = toolTipsList.stream().skip(1L).collect(Collectors.joining()).toLowerCase();
        String allMixed = Stream.of(ItemListOverlay.tryGetItemStackName(itemStack), toolTipsMixed).collect(Collectors.joining()).toLowerCase();
        for (SearchArgument searchArgument2 : arguments.stream().filter(searchArgument -> !searchArgument.isInclude()).collect(Collectors.toList())) {
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && mod.toLowerCase().contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && toolTipsMixed.contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (!searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || !allMixed.contains(searchArgument2.getText().toLowerCase())) continue;
            return false;
        }
        for (SearchArgument searchArgument2 : arguments.stream().filter(SearchArgument::isInclude).collect(Collectors.toList())) {
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && !mod.toLowerCase().contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && !toolTipsMixed.contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (!searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || allMixed.contains(searchArgument2.getText().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.rectangle.contains(double_1, double_2)) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (ClientHelper.isCheating() && !player.field_71071_by.func_70445_o().func_190926_b() && Minecraft.func_71410_x().func_71356_B()) {
                ClientHelper.sendDeletePacket();
                return true;
            }
            if (!player.field_71071_by.func_70445_o().func_190926_b() && Minecraft.func_71410_x().func_71356_B()) {
                return false;
            }
            if (this.onMouseClick(int_1, double_1, double_2)) {
                return true;
            }
            for (IWidget widget : this.getListeners()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IWidget> getListeners() {
        return this.widgets;
    }
}

