/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.KeyBindHelper;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemSlotWidget
extends Gui
implements HighlightableWidget {
    private static final ResourceLocation RECIPE_GUI = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<ItemStack> itemList = new LinkedList<ItemStack>();
    private boolean drawBackground;
    private boolean showToolTips;
    private boolean clickToMoreRecipes;
    private boolean drawHighlightedBackground;
    private int x;
    private int y;

    public ItemSlotWidget(int x, int y, ItemStack itemStack, boolean drawBackground, boolean showToolTips) {
        this(x, y, Collections.singletonList(itemStack), drawBackground, showToolTips);
    }

    public ItemSlotWidget(int x, int y, List<ItemStack> itemList, boolean drawBackground, boolean showToolTips) {
        this.itemList = itemList;
        this.drawBackground = drawBackground;
        this.showToolTips = showToolTips;
        this.x = x;
        this.y = y;
        this.clickToMoreRecipes = false;
        this.drawHighlightedBackground = true;
    }

    public ItemSlotWidget(int x, int y, List<ItemStack> itemList, boolean drawBackground, boolean showToolTips, boolean clickToMoreRecipes) {
        this(x, y, itemList, drawBackground, showToolTips);
        this.clickToMoreRecipes = clickToMoreRecipes;
    }

    public void setDrawHighlightedBackground(boolean drawHighlightedBackground) {
        this.drawHighlightedBackground = drawHighlightedBackground;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    @Override
    public List<IWidget> getListeners() {
        return new ArrayList<IWidget>();
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        ItemStack itemStack = this.getCurrentStack();
        if (this.drawBackground) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RECIPE_GUI);
            this.func_73729_b(this.x - 1, this.y - 1, 0, 222, 18, 18);
        }
        if (this.drawHighlightedBackground && this.isHighlighted(mouseX, mouseY)) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.func_73733_a(this.x, this.y, this.x + 16, this.y + 16, -2130706433, -2130706433);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        if (!itemStack.func_190926_b()) {
            RenderHelper.func_74520_c();
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            itemRenderer.field_77023_b = 200.0f;
            itemRenderer.func_180450_b(itemStack, this.x, this.y);
            itemRenderer.func_180453_a(Minecraft.func_71410_x().field_71466_p, itemStack, this.x, this.y, this.getItemCountOverlay(itemStack));
            itemRenderer.field_77023_b = 0.0f;
        }
        if (!itemStack.func_190926_b() && this.isHighlighted(mouseX, mouseY) && this.showToolTips) {
            this.drawToolTip(itemStack);
        }
    }

    protected void drawToolTip(ItemStack itemStack) {
        List<String> toolTip = this.getTooltip(itemStack);
        GuiHelper.getLastOverlay().addTooltip(new QueuedTooltip(ClientHelper.getMouseLocation(), toolTip));
    }

    protected List<String> getTooltip(ItemStack itemStack) {
        String modString = "\u00a79\u00a7o" + ClientHelper.getModFromItemStack(itemStack);
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList toolTip = Lists.newArrayList(ItemListOverlay.tryGetItemStackToolTip(itemStack));
        toolTip.addAll(this.getExtraToolTips(itemStack));
        for (String s : Lists.newArrayList((Iterable)toolTip)) {
            if (!s.equalsIgnoreCase(modString)) continue;
            toolTip.remove(s);
        }
        toolTip.add(modString);
        return toolTip;
    }

    protected List<String> getExtraToolTips(ItemStack stack) {
        return Lists.newArrayList();
    }

    protected String getItemCountOverlay(ItemStack currentStack) {
        return "";
    }

    public ItemStack getCurrentStack() {
        if (this.itemList.size() == 0) {
            return new ItemStack((IItemProvider)Items.field_190931_a);
        }
        return this.itemList.get(MathHelper.func_76128_c((double)((double)(System.currentTimeMillis() / 500L) % (double)this.itemList.size() / 1.0)));
    }

    public void setItemList(List<ItemStack> itemList) {
        this.itemList = itemList;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x - 1, this.y - 1, 18, 18);
    }

    @Override
    public boolean onMouseClick(int button, double mouseX, double mouseY) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.getBounds().contains(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.executeRecipeKeyBind(this.getCurrentStack().func_77946_l());
            }
            if (button == 1) {
                return ClientHelper.executeUsageKeyBind(this.getCurrentStack().func_77946_l());
            }
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.getBounds().contains(ClientHelper.getMouseLocation())) {
            if (KeyBindHelper.RECIPE.func_197976_a(int_1, int_2)) {
                return ClientHelper.executeRecipeKeyBind(this.getCurrentStack().func_77946_l());
            }
            if (KeyBindHelper.USAGE.func_197976_a(int_1, int_2)) {
                return ClientHelper.executeUsageKeyBind(this.getCurrentStack());
            }
        }
        return false;
    }
}

