/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.rei.client.ClientHelper;

public class QueuedTooltip {
    private Point location;
    private List<String> text;

    protected QueuedTooltip(Point location, List<String> text) {
        this.location = location;
        this.text = new LinkedList<String>(text);
    }

    public static QueuedTooltip create(Point location, List<String> text) {
        return new QueuedTooltip(location, text);
    }

    public static QueuedTooltip create(Point location, String ... text) {
        return QueuedTooltip.create(location, Lists.newArrayList((Object[])text));
    }

    public static QueuedTooltip create(List<String> text) {
        return QueuedTooltip.create(ClientHelper.getMouseLocation(), text);
    }

    public static QueuedTooltip create(String ... text) {
        return QueuedTooltip.create(ClientHelper.getMouseLocation(), text);
    }

    public Point getLocation() {
        return this.location;
    }

    public List<String> getText() {
        return this.text;
    }
}

