/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.RelativePoint;
import me.shedaniel.rei.client.ConfigManager;
import me.shedaniel.rei.gui.RecipeViewingGui;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.DraggableWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class RecipeChoosePageWidget
extends DraggableWidget {
    private int currentPage;
    private int maxPage;
    private Rectangle bounds;
    private Rectangle grabBounds;
    private Rectangle dragBounds;
    private List<IWidget> widgets;
    private RecipeViewingGui recipeViewingScreen;
    private TextFieldWidget textFieldWidget;
    private RecipeBaseWidget base1;
    private RecipeBaseWidget base2;
    private ButtonWidget btnDone;

    public RecipeChoosePageWidget(RecipeViewingGui recipeViewingScreen, int currentPage, int maxPage) {
        super(RecipeChoosePageWidget.getPointFromConfig());
        this.recipeViewingScreen = recipeViewingScreen;
        this.currentPage = currentPage;
        this.maxPage = maxPage;
        this.initWidgets(this.getMidPoint());
    }

    private static Point getPointFromConfig() {
        MainWindow window = Minecraft.func_71410_x().field_195558_d;
        RelativePoint point = RoughlyEnoughItemsCore.getConfigManager().getConfig().choosePageDialogPoint;
        return new Point((int)point.getX(window.func_198107_o()), (int)point.getY(window.func_198087_p()));
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getGrabBounds() {
        return this.grabBounds;
    }

    @Override
    public Rectangle getDragBounds() {
        return this.dragBounds;
    }

    @Override
    public boolean isHighlighted(int mouseX, int mouseY) {
        return this.getBounds().contains(mouseX, mouseY) || new Rectangle(this.bounds.x + this.bounds.width - 50, this.bounds.y + this.bounds.height - 3, 50, 36).contains(mouseX, mouseY);
    }

    @Override
    public void updateWidgets(Point midPoint) {
        this.bounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 40);
        this.grabBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 16);
        this.dragBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 70);
        this.base1.getBounds().setLocation(this.bounds.x + this.bounds.width - 50, this.bounds.y + this.bounds.height - 6);
        this.base2.getBounds().setBounds(this.bounds);
        this.textFieldWidget.getBounds().setLocation(this.bounds.x + 7, this.bounds.y + 16);
        this.btnDone.getBounds().setLocation(this.bounds.x + this.bounds.width - 45, this.bounds.y + this.bounds.height + 3);
    }

    @Override
    protected void initWidgets(Point midPoint) {
        this.bounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 40);
        this.grabBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 16);
        this.dragBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 70);
        this.widgets = Lists.newArrayList();
        this.base1 = new RecipeBaseWidget(new Rectangle(this.bounds.x + this.bounds.width - 50, this.bounds.y + this.bounds.height - 6, 50, 36));
        this.widgets.add(this.base1);
        this.base2 = new RecipeBaseWidget(this.bounds);
        this.widgets.add(this.base2);
        this.widgets.add(new IWidget(){

            @Override
            public List<IWidget> getListeners() {
                return Lists.newArrayList();
            }

            @Override
            public void draw(int i, int i1, float v) {
                Minecraft.func_71410_x().field_71466_p.func_211126_b(I18n.func_135052_a((String)"text.rei.choose_page", (Object[])new Object[0]), (float)(((RecipeChoosePageWidget)RecipeChoosePageWidget.this).bounds.x + 5), (float)(((RecipeChoosePageWidget)RecipeChoosePageWidget.this).bounds.y + 5), 0x404040);
                String endString = String.format(" /%d", RecipeChoosePageWidget.this.maxPage);
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(endString);
                Minecraft.func_71410_x().field_71466_p.func_211126_b(endString, (float)(((RecipeChoosePageWidget)RecipeChoosePageWidget.this).bounds.x + ((RecipeChoosePageWidget)RecipeChoosePageWidget.this).bounds.width - 5 - width), (float)(((RecipeChoosePageWidget)RecipeChoosePageWidget.this).bounds.y + 22), 0x404040);
            }
        });
        String endString = String.format(" /%d", this.maxPage);
        int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(endString);
        this.textFieldWidget = new TextFieldWidget(this.bounds.x + 7, this.bounds.y + 16, this.bounds.width - width - 12, 18);
        this.widgets.add(this.textFieldWidget);
        this.textFieldWidget.stripInvaild = s -> {
            StringBuilder stringBuilder_1 = new StringBuilder();
            for (char char_1 : s.toCharArray()) {
                if (!Character.isDigit(char_1)) continue;
                stringBuilder_1.append(char_1);
            }
            return stringBuilder_1.toString();
        };
        this.textFieldWidget.setText(String.valueOf(this.currentPage + 1));
        this.btnDone = new ButtonWidget(this.bounds.x + this.bounds.width - 45, this.bounds.y + this.bounds.height + 3, 40, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                ((RecipeChoosePageWidget)RecipeChoosePageWidget.this).recipeViewingScreen.page = MathHelper.func_76125_a((int)(RecipeChoosePageWidget.this.getIntFromString(RecipeChoosePageWidget.this.textFieldWidget.getText()).orElse(0) - 1), (int)0, (int)(RecipeChoosePageWidget.this.recipeViewingScreen.getTotalPages(RecipeChoosePageWidget.this.recipeViewingScreen.getSelectedCategory()) - 1));
                ((RecipeChoosePageWidget)RecipeChoosePageWidget.this).recipeViewingScreen.choosePageActivated = false;
                RecipeChoosePageWidget.this.recipeViewingScreen.func_73866_w_();
            }
        };
        this.widgets.add(this.btnDone);
        this.textFieldWidget.setFocused(true);
    }

    @Override
    public Point processMidPoint(Point midPoint, Point mouse, Point startPoint, MainWindow window, int relateX, int relateY) {
        return new Point(MathHelper.func_76125_a((int)(mouse.x - relateX), (int)(this.getDragBounds().width / 2), (int)(window.func_198107_o() - this.getDragBounds().width / 2)), MathHelper.func_76125_a((int)(mouse.y - relateY), (int)20, (int)(window.func_198087_p() - 50)));
    }

    @Override
    public List<IWidget> getListeners() {
        return this.widgets;
    }

    @Override
    public void draw(int i, int i1, float v) {
        this.widgets.forEach(widget -> {
            RenderHelper.func_74518_a();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)600.0f);
            widget.draw(i, i1, v);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-600.0f);
        });
    }

    public boolean charTyped(char char_1, int int_1) {
        for (IWidget widget : this.widgets) {
            if (!widget.charTyped(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 335 || int_1 == 257) {
            this.recipeViewingScreen.page = MathHelper.func_76125_a((int)(this.getIntFromString(this.textFieldWidget.getText()).orElse(0) - 1), (int)0, (int)(this.recipeViewingScreen.getTotalPages(this.recipeViewingScreen.getSelectedCategory()) - 1));
            this.recipeViewingScreen.choosePageActivated = false;
            this.recipeViewingScreen.func_73866_w_();
            return true;
        }
        for (IWidget widget : this.widgets) {
            if (!widget.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return false;
    }

    public Optional<Integer> getIntFromString(String s) {
        try {
            return Optional.of(Integer.valueOf(s));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Override
    public void onMouseReleaseMidPoint(Point midPoint) {
        ConfigManager configManager = RoughlyEnoughItemsCore.getConfigManager();
        MainWindow window = Minecraft.func_71410_x().field_195558_d;
        configManager.getConfig().choosePageDialogPoint = new RelativePoint(midPoint.getX() / (double)window.func_198107_o(), midPoint.getY() / (double)window.func_198087_p());
        try {
            configManager.saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

