/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class SpeedCraftingButtonWidget
extends ButtonWidget {
    private final Supplier<RecipeDisplay> displaySupplier;
    private final SpeedCraftFunctional functional;

    public SpeedCraftingButtonWidget(Rectangle rectangle, String text, SpeedCraftFunctional functional, Supplier<RecipeDisplay> displaySupplier) {
        super(rectangle, text);
        this.displaySupplier = displaySupplier;
        this.functional = functional;
    }

    @Override
    public void onPressed(int button, double mouseX, double mouseY) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiHelper.getLastGuiContainer());
        GuiHelper.getLastOverlay().init();
        this.functional.performAutoCraft((Gui)GuiHelper.getLastGuiContainer(), this.displaySupplier.get());
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.enabled = this.functional != null && this.functional.acceptRecipe((Gui)GuiHelper.getLastGuiContainer(), this.displaySupplier.get());
        super.draw(mouseX, mouseY, partialTicks);
        if (this.getBounds().contains(mouseX, mouseY)) {
            if (this.enabled) {
                GuiHelper.getLastOverlay().addTooltip(new QueuedTooltip(ClientHelper.getMouseLocation(), Arrays.asList(I18n.func_135052_a((String)"text.speed_craft.move_items", (Object[])new Object[0]))));
            } else {
                GuiHelper.getLastOverlay().addTooltip(new QueuedTooltip(ClientHelper.getMouseLocation(), Arrays.asList(I18n.func_135052_a((String)"text.speed_craft.failed_move_items", (Object[])new Object[0]))));
            }
        }
    }
}

