/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.ItemSlotWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.plugin.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.plugin.DefaultShapedDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DefaultCraftingCategory
implements RecipeCategory<DefaultCraftingDisplay> {
    private static final ResourceLocation DISPLAY_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/display.png");

    @Override
    public ResourceLocation getLocation() {
        return DefaultPlugin.CRAFTING;
    }

    @Override
    public ItemStack getCategoryIcon() {
        return new ItemStack((IItemProvider)Blocks.field_150462_ai.func_199767_j());
    }

    @Override
    public String getCategoryName() {
        return I18n.func_135052_a((String)"category.rei.crafting", (Object[])new Object[0]);
    }

    @Override
    public List<IWidget> setupDisplay(Supplier<DefaultCraftingDisplay> recipeDisplaySupplier, Rectangle bounds) {
        final Point startPoint = new Point((int)bounds.getCenterX() - 58, (int)bounds.getCenterY() - 27);
        LinkedList<IWidget> widgets = new LinkedList<IWidget>(Arrays.asList(new RecipeBaseWidget(bounds){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                super.draw(mouseX, mouseY, partialTicks);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.func_74518_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DISPLAY_TEXTURE);
                this.func_73729_b(startPoint.x, startPoint.y, 0, 0, 116, 54);
            }
        }));
        List<List<ItemStack>> input = recipeDisplaySupplier.get().getInput();
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(new ItemSlotWidget(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18, Lists.newArrayList(), true, true, true));
            }
        }
        for (int i = 0; i < input.size(); ++i) {
            if (recipeDisplaySupplier.get() instanceof DefaultShapedDisplay) {
                if (input.get(i).isEmpty()) continue;
                ((ItemSlotWidget)slots.get(this.getSlotWithSize(recipeDisplaySupplier.get(), i))).setItemList(input.get(i));
                continue;
            }
            if (input.get(i).isEmpty()) continue;
            ((ItemSlotWidget)slots.get(i)).setItemList(input.get(i));
        }
        widgets.addAll(slots);
        widgets.add((Object)new ItemSlotWidget(startPoint.x + 95, startPoint.y + 19, recipeDisplaySupplier.get().getOutput(), false, true, true){

            @Override
            protected String getItemCountOverlay(ItemStack currentStack) {
                if (currentStack.func_190916_E() == 1) {
                    return "";
                }
                if (currentStack.func_190916_E() < 1) {
                    return "\u00a7c" + currentStack.func_190916_E();
                }
                return currentStack.func_190916_E() + "";
            }
        });
        return widgets;
    }

    private int getSlotWithSize(DefaultCraftingDisplay recipeDisplay, int num) {
        if (recipeDisplay.getWidth() == 1) {
            if (num == 1) {
                return 3;
            }
            if (num == 2) {
                return 6;
            }
        }
        if (recipeDisplay.getWidth() == 2) {
            if (num == 2) {
                return 3;
            }
            if (num == 3) {
                return 4;
            }
            if (num == 4) {
                return 6;
            }
            if (num == 5) {
                return 7;
            }
        }
        return num;
    }
}

