/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.IREIPlugin;
import me.shedaniel.rei.api.ItemRegistry;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.PluginFunction;
import me.shedaniel.rei.api.REIPlugin;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.plugin.BrewingRecipe;
import me.shedaniel.rei.plugin.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.DefaultShapelessDisplay;
import me.shedaniel.rei.plugin.DefaultSmeltingCategory;
import me.shedaniel.rei.plugin.DefaultSmeltingDisplay;
import me.shedaniel.rei.utils.PotionRecipeUtils;
import me.shedaniel.rei.utils.RecipeBookUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;

@IREIPlugin(identifier="roughlyenoughitems:default_plugin")
public class DefaultPlugin
implements REIPlugin {
    public static final ResourceLocation CRAFTING = new ResourceLocation("roughlyenoughitems", "plugins/crafting");
    public static final ResourceLocation SMELTING = new ResourceLocation("roughlyenoughitems", "plugins/smelting");
    public static final ResourceLocation BREWING = new ResourceLocation("roughlyenoughitems", "plugins/brewing");
    public static final ResourceLocation PLUGIN = new ResourceLocation("roughlyenoughitems", "default_plugin");

    @Override
    public void onFirstLoad(PluginDisabler pluginDisabler) {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().loadDefaultPlugin) {
            pluginDisabler.disablePluginFunction(PLUGIN, PluginFunction.REGISTER_ITEMS);
            pluginDisabler.disablePluginFunction(PLUGIN, PluginFunction.REGISTER_CATEGORIES);
            pluginDisabler.disablePluginFunction(PLUGIN, PluginFunction.REGISTER_RECIPE_DISPLAYS);
            pluginDisabler.disablePluginFunction(PLUGIN, PluginFunction.REGISTER_SPEED_CRAFT);
        }
    }

    @Override
    public void registerItems(ItemRegistry itemRegisterer) {
        ForgeRegistries.ITEMS.forEach(o -> {
            try {
                if (o instanceof Item) {
                    Item item = o;
                    if (item.equals(Items.field_151134_bR)) {
                        itemRegisterer.registerItemStack(item.func_190903_i());
                    } else {
                        Optional<NonNullList<ItemStack>> optionalStacks = itemRegisterer.getAlterativeStacks(item);
                        if (optionalStacks.isPresent()) {
                            itemRegisterer.registerItemStack((ItemStack[])optionalStacks.get().toArray((Object[])new ItemStack[0]));
                        } else {
                            itemRegisterer.registerItemStack(item.func_190903_i());
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ForgeRegistries.ENCHANTMENTS.forEach(o -> {
            if (o instanceof Enchantment) {
                Enchantment enchantment = o;
                for (int i = enchantment.func_77319_d(); i < enchantment.func_77325_b(); ++i) {
                    HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
                    map.put(enchantment, i);
                    ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151134_bR);
                    EnchantmentHelper.func_82782_a(map, (ItemStack)itemStack);
                    itemRegisterer.registerItemStack(Items.field_151134_bR, itemStack);
                }
            }
        });
    }

    @Override
    public void registerPluginCategories(RecipeHelper recipeHelper) {
        recipeHelper.registerCategory(new DefaultCraftingCategory());
        recipeHelper.registerCategory(new DefaultSmeltingCategory());
        recipeHelper.registerCategory(new DefaultBrewingCategory());
    }

    @Override
    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        for (IRecipe value : recipeHelper.getRecipeManager().func_199510_b()) {
            if (value instanceof ShapelessRecipe) {
                recipeHelper.registerDisplay(CRAFTING, new DefaultShapelessDisplay((ShapelessRecipe)value));
                continue;
            }
            if (value instanceof ShapedRecipe) {
                recipeHelper.registerDisplay(CRAFTING, new DefaultShapedDisplay((ShapedRecipe)value));
                continue;
            }
            if (!(value instanceof FurnaceRecipe)) continue;
            recipeHelper.registerDisplay(SMELTING, new DefaultSmeltingDisplay((FurnaceRecipe)value));
        }
        ArrayList registeredPotionTypes = Lists.newArrayList();
        ArrayList potionItemConversions = Lists.newArrayList();
        List<Ingredient> potionItems = PotionRecipeUtils.getPotionItems();
        PotionRecipeUtils.getPotionItemConversions().forEach(o -> {
            try {
                IRegistryDelegate input = PotionRecipeUtils.getInputFromMixPredicate(o, IRegistryDelegate.class);
                IRegistryDelegate output = PotionRecipeUtils.getOutputFromMixPredicate(o, IRegistryDelegate.class);
                Ingredient reagent = PotionRecipeUtils.getReagentFromMixPredicate(o);
                potionItemConversions.add(new BrewingRecipe((Item)input.get(), reagent, (Item)output.get()));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        PotionRecipeUtils.getPotionTypeConversions().forEach(o -> {
            try {
                IRegistryDelegate input = PotionRecipeUtils.getInputFromMixPredicate(o, IRegistryDelegate.class);
                IRegistryDelegate output = PotionRecipeUtils.getOutputFromMixPredicate(o, IRegistryDelegate.class);
                Ingredient reagent = PotionRecipeUtils.getReagentFromMixPredicate(o);
                if (!registeredPotionTypes.contains(input.get())) {
                    this.registerPotionType(recipeHelper, registeredPotionTypes, potionItemConversions, (PotionType)input.get());
                }
                if (!registeredPotionTypes.contains(output.get())) {
                    this.registerPotionType(recipeHelper, registeredPotionTypes, potionItemConversions, (PotionType)output.get());
                }
                potionItems.stream().map(Ingredient::func_193365_a).forEach(itemStacks -> Arrays.stream(itemStacks).forEach(stack -> recipeHelper.registerDisplay(BREWING, new DefaultBrewingDisplay(PotionUtils.func_185188_a((ItemStack)stack.func_77946_l(), (PotionType)((PotionType)input.get())), reagent, PotionUtils.func_185188_a((ItemStack)stack.func_77946_l(), (PotionType)((PotionType)output.get()))))));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        List<ItemStack> arrowStack = Arrays.asList(Items.field_151032_g.func_190903_i());
        RoughlyEnoughItemsCore.getItemRegistry().getItemList().stream().filter(stack -> stack.func_77973_b().equals(Items.field_185156_bI)).forEach(stack -> {
            int i;
            ArrayList<List<ItemStack>> input = new ArrayList<List<ItemStack>>();
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            input.add(Arrays.asList(stack));
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            ItemStack outputStack = new ItemStack((IItemProvider)Items.field_185167_i, 8);
            PotionUtils.func_185188_a((ItemStack)outputStack, (PotionType)PotionUtils.func_185191_c((ItemStack)stack));
            PotionUtils.func_185184_a((ItemStack)outputStack, (Collection)PotionUtils.func_185190_b((ItemStack)stack));
            ArrayList output = Lists.newArrayList((Object[])new ItemStack[]{outputStack});
            recipeHelper.registerDisplay(CRAFTING, new DefaultCustomDisplay(input, output));
        });
    }

    private void registerPotionType(RecipeHelper recipeHelper, List<PotionType> list, List<BrewingRecipe> potionItemConversions, PotionType potion) {
        list.add(potion);
        potionItemConversions.forEach(recipe -> recipeHelper.registerDisplay(BREWING, new DefaultBrewingDisplay(PotionUtils.func_185188_a((ItemStack)recipe.input.func_190903_i(), (PotionType)potion), recipe.ingredient, PotionUtils.func_185188_a((ItemStack)recipe.output.func_190903_i(), (PotionType)potion))));
    }

    @Override
    public void registerSpeedCraft(RecipeHelper recipeHelper) {
        recipeHelper.registerSpeedCraftButtonArea(BREWING, null);
        recipeHelper.registerSpeedCraftFunctional(CRAFTING, new SpeedCraftFunctional<DefaultCraftingDisplay>(){

            @Override
            public Class[] getFunctioningFor() {
                return new Class[]{GuiInventory.class, GuiCrafting.class};
            }

            @Override
            public boolean performAutoCraft(Gui gui, DefaultCraftingDisplay recipe) {
                if (!recipe.getRecipe().isPresent()) {
                    return false;
                }
                try {
                    if (gui.getClass().isAssignableFrom(GuiCrafting.class)) {
                        RecipeBookUtils.getGhostRecipe(((GuiCrafting)gui).func_194310_f()).func_192682_a();
                    } else if (gui.getClass().isAssignableFrom(GuiInventory.class)) {
                        RecipeBookUtils.getGhostRecipe(((GuiInventory)gui).func_194310_f()).func_192682_a();
                    } else {
                        return false;
                    }
                    Minecraft.func_71410_x().field_71442_b.func_203413_a(Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c, (IRecipe)recipe.getRecipe().get(), GuiScreen.func_146272_n());
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }

            @Override
            public boolean acceptRecipe(Gui gui, DefaultCraftingDisplay recipe) {
                return gui instanceof GuiCrafting || gui instanceof GuiInventory && recipe.getHeight() < 3 && recipe.getWidth() < 3;
            }
        });
        recipeHelper.registerSpeedCraftFunctional(SMELTING, new SpeedCraftFunctional<DefaultSmeltingDisplay>(){

            @Override
            public Class[] getFunctioningFor() {
                return new Class[]{GuiFurnace.class};
            }

            @Override
            public boolean performAutoCraft(Gui gui, DefaultSmeltingDisplay recipe) {
                if (!recipe.getRecipe().isPresent()) {
                    return false;
                }
                try {
                    if (!(gui instanceof GuiFurnace)) {
                        return false;
                    }
                    RecipeBookUtils.getGhostRecipe(((GuiFurnace)gui).func_194310_f()).func_192682_a();
                    Minecraft.func_71410_x().field_71442_b.func_203413_a(Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c, (IRecipe)recipe.getRecipe().get(), GuiScreen.func_146272_n());
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }

            @Override
            public boolean acceptRecipe(Gui gui, DefaultSmeltingDisplay recipe) {
                return gui instanceof GuiFurnace;
            }
        });
    }

    @Override
    public int getPriority() {
        return -1;
    }
}

