/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.utils;

import java.lang.reflect.Field;
import java.util.Optional;
import me.shedaniel.rei.RoughlyEnoughItemsCore;

public class ReflectionUtils {
    public static <T> Optional<T> getField(Object parent, Class<T> clazz, String ... possibleNames) {
        for (String possibleName : possibleNames) {
            try {
                Field field = parent.getClass().getDeclaredField(possibleName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return Optional.ofNullable(clazz.cast(field.get(parent)));
            }
            catch (Exception exception) {
            }
        }
        RoughlyEnoughItemsCore.LOGGER.warn("Reflection failed! Trying to get " + possibleNames + " from %s", (Object)clazz.getName());
        return Optional.empty();
    }

    public static <T> Optional<T> getField(Object parent, Class<T> clazz, int index) {
        try {
            Field field = parent.getClass().getDeclaredFields()[index];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return Optional.ofNullable(clazz.cast(field.get(parent)));
        }
        catch (Exception exception) {
            RoughlyEnoughItemsCore.LOGGER.warn("Reflection failed! Trying to get #" + index + " from %s", (Object)clazz.getName());
            return Optional.empty();
        }
    }

    public static <T> Optional<T> getStaticField(Class parentClass, Class<T> clazz, String ... possibleNames) {
        for (String possibleName : possibleNames) {
            try {
                Field field = parentClass.getDeclaredField(possibleName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return Optional.ofNullable(clazz.cast(field.get(null)));
            }
            catch (Exception exception) {
            }
        }
        RoughlyEnoughItemsCore.LOGGER.warn("Reflection failed! Trying to get " + possibleNames + " from %s", (Object)clazz.getName());
        return Optional.empty();
    }

    public static <T> Optional<T> getStaticField(Class parentClass, Class<T> clazz, int index) {
        try {
            Field field = parentClass.getDeclaredFields()[index];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return Optional.ofNullable(clazz.cast(field.get(null)));
        }
        catch (Exception exception) {
            RoughlyEnoughItemsCore.LOGGER.warn("Reflection failed! Trying to get #" + index + " from %s", (Object)clazz.getName());
            return Optional.empty();
        }
    }

    public static class ReflectionException
    extends Exception {
    }
}

