/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.Configuration;
import bl4ckscor3.mod.sit.EntitySit;
import bl4ckscor3.mod.sit.SitUtil;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import trikzon.snowvariants.blocks.SnowSlab;

@Mod.EventBusSubscriber(modid="sit")
public class SitHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getFace() == Direction.UP && !SitUtil.isPlayerSitting(event.getPlayer())) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = world.func_180495_p(pos);
            Block block = world.func_180495_p(pos).func_177230_c();
            PlayerEntity player = event.getPlayer();
            if (SitHandler.isValidBlock(world, pos, state, block) && SitHandler.isPlayerInRange(player, pos) && !SitUtil.isOccupied((IWorld)world, pos) && player.func_184614_ca().func_190926_b() && world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a())) {
                if (block instanceof SlabBlock && (!state.func_196959_b((IProperty)SlabBlock.field_196505_a) || state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.BOTTOM)) {
                    return;
                }
                if (block instanceof StairsBlock && (!state.func_196959_b((IProperty)StairsBlock.field_176308_b) || state.func_177229_b((IProperty)StairsBlock.field_176308_b) != Half.BOTTOM)) {
                    return;
                }
                EntitySit sit = new EntitySit(world, pos);
                if (SitUtil.addSitEntity((IWorld)world, pos, sit)) {
                    world.func_217376_c((Entity)sit);
                    player.func_184220_m((Entity)sit);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        EntitySit entity;
        if (!event.getWorld().func_201670_d() && (entity = SitUtil.getSitEntity(event.getWorld(), event.getPos())) != null && SitUtil.removeSitEntity(event.getWorld(), event.getPos())) {
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Entity player;
        if (!event.getWorldObj().field_72995_K && event.isDismounting() && (player = event.getEntityBeingMounted()) instanceof EntitySit && SitUtil.removeSitEntity((IWorld)event.getWorldObj(), player.func_180425_c())) {
            player.func_70106_y();
        }
    }

    private static boolean isValidBlock(World world, BlockPos pos, BlockState state, Block block) {
        boolean isValid;
        boolean bl = isValid = block instanceof SlabBlock || block instanceof StairsBlock || SitHandler.isModBlock(block);
        if (!isValid && block instanceof BedBlock && !((state = world.func_180495_p(pos.func_177972_a(state.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD ? ((Direction)state.func_177229_b((IProperty)BedBlock.field_185512_D)).func_176734_d() : (Direction)state.func_177229_b((IProperty)BedBlock.field_185512_D)))).func_177230_c() instanceof BedBlock)) {
            isValid = true;
        }
        return isValid;
    }

    private static boolean isModBlock(Block block) {
        return ModList.get().isLoaded("snowvariants") && block instanceof SnowSlab;
    }

    private static boolean isPlayerInRange(PlayerEntity player, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        int blockReachDistance = (Integer)Configuration.CONFIG.blockReachDistance.get();
        if (blockReachDistance == 0) {
            return playerPos.func_177956_o() - pos.func_177956_o() <= 1 && playerPos.func_177958_n() - pos.func_177958_n() == 0 && playerPos.func_177952_p() - pos.func_177952_p() == 0;
        }
        pos = pos.func_177963_a(0.5, 0.5, 0.5);
        AxisAlignedBB range = new AxisAlignedBB((double)(pos.func_177958_n() + blockReachDistance), (double)(pos.func_177956_o() + blockReachDistance), (double)(pos.func_177952_p() + blockReachDistance), (double)(pos.func_177958_n() - blockReachDistance), (double)(pos.func_177956_o() - blockReachDistance), (double)(pos.func_177952_p() - blockReachDistance));
        return range.field_72340_a <= (double)(playerPos = playerPos.func_177963_a(0.5, 0.5, 0.5)).func_177958_n() && range.field_72338_b <= (double)playerPos.func_177956_o() && range.field_72339_c <= (double)playerPos.func_177952_p() && range.field_72336_d >= (double)playerPos.func_177958_n() && range.field_72337_e >= (double)playerPos.func_177956_o() && range.field_72334_f >= (double)playerPos.func_177952_p();
    }
}

