/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowmancy.entity;

import bl4ckscor3.mod.snowmancy.Snowmancy;
import bl4ckscor3.mod.snowmancy.entity.ai.SnowmanAIAttackMelee;
import bl4ckscor3.mod.snowmancy.entity.ai.SnowmanAIAttackRanged;
import bl4ckscor3.mod.snowmancy.util.EnumAttackType;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntitySnowmanCompanion
extends EntityGolem
implements IRangedAttackMob {
    private static final DataParameter<Boolean> GOLDEN_NOSE = EntityDataManager.func_187226_a(EntitySnowmanCompanion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> ATTACK_TYPE = EntityDataManager.func_187226_a(EntitySnowmanCompanion.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntitySnowmanCompanion.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> EVERCOLD = EntityDataManager.func_187226_a(EntitySnowmanCompanion.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntitySnowmanCompanion(World world) {
        super(world);
        this.func_70105_a(0.35f, 0.9f);
    }

    public EntitySnowmanCompanion(World world, boolean goldenNose, String attackType, float damage, boolean evercold) {
        super(world);
        this.func_70105_a(0.35f, 0.9f);
        this.field_70180_af.func_187227_b(GOLDEN_NOSE, (Object)goldenNose);
        this.field_70180_af.func_187227_b(ATTACK_TYPE, (Object)attackType);
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        this.field_70180_af.func_187227_b(EVERCOLD, (Object)evercold);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GOLDEN_NOSE, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TYPE, (Object)EnumAttackType.HIT.name());
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EVERCOLD, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SnowmanAIAttackMelee(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SnowmanAIAttackRanged(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, IMob.field_82192_a));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isEvercold() && this.field_70170_p.func_180494_b(this.func_180425_c()).func_150561_m() != Biome.TempCategory.COLD) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && hand == EnumHand.MAIN_HAND) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.createItem());
            this.func_70106_y();
        }
        return super.func_184645_a(player, hand);
    }

    public ItemStack createItem() {
        ItemStack stack = new ItemStack(Snowmancy.FROZEN_SNOWMAN);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityEgg throwableEntity;
        EnumAttackType type = EnumAttackType.valueOf(this.getAttackType());
        switch (type) {
            case ARROW: {
                throwableEntity = ((ItemArrow)Items.field_151032_g).func_185052_a(this.field_70170_p, new ItemStack(Items.field_151032_g, 1), (EntityLivingBase)this);
                break;
            }
            case EGG: {
                throwableEntity = new EntityEgg(this.field_70170_p, (EntityLivingBase)this);
                break;
            }
            case SNOWBALL: {
                throwableEntity = new EntitySnowball(this.field_70170_p, (EntityLivingBase)this);
                break;
            }
            default: {
                return;
            }
        }
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t - this.field_70165_t;
        double d2 = d0 - throwableEntity.field_70163_u;
        double d3 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        ((IProjectile)throwableEntity).func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)throwableEntity);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(GOLDEN_NOSE, (Object)tag.func_74767_n("goldenCarrot"));
        this.field_70180_af.func_187227_b(ATTACK_TYPE, (Object)tag.func_74779_i("attackType"));
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(tag.func_74760_g("damage")));
        this.field_70180_af.func_187227_b(EVERCOLD, (Object)tag.func_74767_n("evercold"));
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74757_a("goldenCarrot", this.isNoseGolden());
        tag.func_74778_a("attackType", this.getAttackType());
        tag.func_74776_a("damage", this.getDamage());
        tag.func_74757_a("evercold", this.isEvercold());
    }

    public boolean isNoseGolden() {
        return (Boolean)this.field_70180_af.func_187225_a(GOLDEN_NOSE);
    }

    public String getAttackType() {
        return (String)this.field_70180_af.func_187225_a(ATTACK_TYPE);
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public boolean isEvercold() {
        return (Boolean)this.field_70180_af.func_187225_a(EVERCOLD);
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

