/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowmancy.tileentity;

import bl4ckscor3.mod.snowmancy.Snowmancy;
import bl4ckscor3.mod.snowmancy.item.ItemBlockEvercoldIce;
import bl4ckscor3.mod.snowmancy.util.EnumAttackType;
import bl4ckscor3.snowmancy.inventory.InventorySnowmanBuilder;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySnowmanBuilder
extends TileEntity
implements ITickable {
    private InventorySnowmanBuilder inventory = new InventorySnowmanBuilder(this);
    private byte progress = 0;
    private final byte maxProgress = (byte)8;

    public void func_73660_a() {
        if (this.canOperate()) {
            for (int i = 0; i < this.inventory.func_70302_i_() - 1; ++i) {
                if (!this.inventory.func_70301_a(i).func_190926_b()) continue;
                this.inventory.getItemHandler().setStackInSlot(this.inventory.func_70302_i_() - 1, ItemStack.field_190927_a);
                this.resetProgress();
                return;
            }
            if (!this.isCraftReady()) {
                ItemStack stack = new ItemStack(Snowmancy.FROZEN_SNOWMAN);
                Item weapon = this.inventory.func_70301_a(this.inventory.func_70302_i_() - 2).func_77973_b();
                NBTTagCompound tag = new NBTTagCompound();
                EnumAttackType attackType = weapon == Items.field_151031_f ? EnumAttackType.ARROW : (weapon == Items.field_151110_aK ? EnumAttackType.EGG : (weapon == Items.field_151126_ay ? EnumAttackType.SNOWBALL : EnumAttackType.HIT));
                tag.func_74757_a("goldenCarrot", this.inventory.func_70301_a(1).func_77973_b() == Items.field_151150_bK);
                tag.func_74778_a("attackType", attackType.name());
                tag.func_74776_a("damage", attackType == EnumAttackType.HIT && weapon instanceof ItemSword ? 4.0f + ((ItemSword)weapon).func_150931_i() : 0.0f);
                tag.func_74757_a("evercold", this.inventory.func_70301_a(0).func_77973_b() instanceof ItemBlockEvercoldIce);
                stack.func_77982_d(tag);
                this.inventory.getItemHandler().setStackInSlot(this.inventory.func_70302_i_() - 1, stack);
            }
        }
    }

    public void increaseProgress() {
        if (this.isCraftReady() && this.progress < 8) {
            this.progress = (byte)(this.progress + 1);
            this.markDirtyClient();
        }
    }

    public void resetProgress() {
        this.progress = 0;
        this.markDirtyClient();
    }

    public boolean isCraftReady() {
        return !this.inventory.func_70301_a(this.inventory.func_70302_i_() - 1).func_190926_b();
    }

    public boolean canOperate() {
        int cooling = 0;
        boolean cold = this.func_145831_w().func_180494_b(this.field_174879_c).func_150561_m() == Biome.TempCategory.COLD;
        boolean medium = this.func_145831_w().func_180494_b(this.field_174879_c).func_150561_m() == Biome.TempCategory.MEDIUM;
        boolean ocean = this.func_145831_w().func_180494_b(this.field_174879_c).func_150561_m() == Biome.TempCategory.OCEAN;
        boolean warm = this.func_145831_w().func_180494_b(this.field_174879_c).func_150561_m() == Biome.TempCategory.WARM;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177230_c() != Snowmancy.EVERCOLD_ICE) continue;
            ++cooling;
        }
        switch (cooling) {
            case 0: 
            case 1: {
                return cold;
            }
            case 2: 
            case 3: {
                return cold || medium || ocean;
            }
        }
        return cold || medium || ocean || warm;
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        NBTTagCompound invTag = (NBTTagCompound)tag.func_74781_a("SnowmanBuilderInventory");
        if (invTag != null) {
            for (int i = 0; i < this.inventory.getContents().size(); ++i) {
                if (!invTag.func_74764_b("Slot" + i)) continue;
                this.inventory.func_70299_a(i, new ItemStack((NBTTagCompound)invTag.func_74781_a("Slot" + i)));
            }
            this.progress = tag.func_74771_c("progress");
        }
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound invTag = new NBTTagCompound();
        for (int i = 0; i < this.inventory.getContents().size(); ++i) {
            invTag.func_74782_a("Slot" + i, (NBTBase)this.inventory.func_70301_a(i).func_77955_b(new NBTTagCompound()));
        }
        tag.func_74782_a("SnowmanBuilderInventory", (NBTBase)invTag);
        tag.func_74774_a("progress", this.progress);
        return super.func_189515_b(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.progress = pkt.func_148857_g().func_74771_c("progress");
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(cap, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getItemHandler();
        }
        return (T)super.getCapability(cap, facing);
    }

    public InventorySnowmanBuilder getInventory() {
        return this.inventory;
    }

    public byte getProgress() {
        return this.progress;
    }

    public byte getMaxProgress() {
        return 8;
    }
}

