/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowmancy.tileentity;

import bl4ckscor3.mod.snowmancy.Snowmancy;
import bl4ckscor3.mod.snowmancy.container.SnowmanBuilderContainer;
import bl4ckscor3.mod.snowmancy.inventory.SnowmanBuilderInventory;
import bl4ckscor3.mod.snowmancy.util.EnumAttackType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SnowmanBuilderTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private SnowmanBuilderInventory inventory = new SnowmanBuilderInventory(this);
    private byte progress = 0;
    private final byte maxProgress = (byte)8;
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory.getItemHandler());

    public SnowmanBuilderTileEntity() {
        super(Snowmancy.teTypeBuilder);
    }

    public void func_73660_a() {
        if (this.canOperate()) {
            for (int i = 0; i < this.inventory.func_70302_i_() - 1; ++i) {
                if (!this.inventory.func_70301_a(i).func_190926_b()) continue;
                this.inventory.getItemHandler().setStackInSlot(this.inventory.func_70302_i_() - 1, ItemStack.field_190927_a);
                this.resetProgress();
                return;
            }
            if (!this.isCraftReady()) {
                ItemStack stack = new ItemStack((IItemProvider)Snowmancy.FROZEN_SNOWMAN);
                Item weapon = this.inventory.func_70301_a(this.inventory.func_70302_i_() - 2).func_77973_b();
                CompoundNBT tag = new CompoundNBT();
                EnumAttackType attackType = weapon == Items.field_151031_f ? EnumAttackType.ARROW : (weapon == Items.field_151110_aK ? EnumAttackType.EGG : (weapon == Items.field_151126_ay ? EnumAttackType.SNOWBALL : EnumAttackType.HIT));
                tag.func_74757_a("goldenCarrot", this.inventory.func_70301_a(1).func_77973_b() == Items.field_151150_bK);
                tag.func_74778_a("attackType", attackType.name());
                tag.func_74776_a("damage", attackType == EnumAttackType.HIT && weapon instanceof SwordItem ? 4.0f + ((SwordItem)weapon).func_200894_d() : 0.0f);
                tag.func_74757_a("evercold", this.inventory.func_70301_a(0).func_77973_b() == Snowmancy.EVERCOLD_ICE.func_199767_j());
                stack.func_77982_d(tag);
                this.inventory.getItemHandler().setStackInSlot(this.inventory.func_70302_i_() - 1, stack);
            }
        }
    }

    public void increaseProgress() {
        if (this.isCraftReady() && this.progress < 8) {
            this.progress = (byte)(this.progress + 1);
            this.markDirtyClient();
        }
    }

    public void resetProgress() {
        this.progress = 0;
        this.markDirtyClient();
    }

    public boolean isCraftReady() {
        return !this.inventory.func_70301_a(this.inventory.func_70302_i_() - 1).func_190926_b();
    }

    public boolean canOperate() {
        int cooling = 0;
        boolean cold = this.func_145831_w().func_226691_t_(this.field_174879_c).func_150561_m() == Biome.TempCategory.COLD;
        boolean medium = this.func_145831_w().func_226691_t_(this.field_174879_c).func_150561_m() == Biome.TempCategory.MEDIUM;
        boolean ocean = this.func_145831_w().func_226691_t_(this.field_174879_c).func_150561_m() == Biome.TempCategory.OCEAN;
        boolean warm = this.func_145831_w().func_226691_t_(this.field_174879_c).func_150561_m() == Biome.TempCategory.WARM;
        for (Direction facing : Direction.values()) {
            if (this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177230_c() != Snowmancy.EVERCOLD_ICE) continue;
            ++cooling;
        }
        switch (cooling) {
            case 0: 
            case 1: {
                return cold;
            }
            case 2: 
            case 3: {
                return cold || medium || ocean;
            }
        }
        return cold || medium || ocean || warm;
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = (CompoundNBT)tag.func_74781_a("SnowmanBuilderInventory");
        if (invTag != null) {
            for (int i = 0; i < this.inventory.getContents().size(); ++i) {
                if (!invTag.func_74764_b("Slot" + i)) continue;
                this.inventory.func_70299_a(i, ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)invTag.func_74781_a("Slot" + i))));
            }
            this.progress = tag.func_74771_c("progress");
        }
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT invTag = new CompoundNBT();
        for (int i = 0; i < this.inventory.getContents().size(); ++i) {
            invTag.func_218657_a("Slot" + i, (INBT)this.inventory.func_70301_a(i).func_77955_b(new CompoundNBT()));
        }
        tag.func_218657_a("SnowmanBuilderInventory", (INBT)invTag);
        tag.func_74774_a("progress", this.progress);
        return super.func_189515_b(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.progress = pkt.func_148857_g().func_74771_c("progress");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public SnowmanBuilderInventory getInventory() {
        return this.inventory;
    }

    public byte getProgress() {
        return this.progress;
    }

    public byte getMaxProgress() {
        return 8;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new SnowmanBuilderContainer(windowId, this.field_145850_b, this.field_174879_c, inv);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(Snowmancy.SNOWMAN_BUILDER.func_149739_a(), new Object[0]);
    }
}

