/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowmancy.entity;

import bl4ckscor3.mod.snowmancy.Snowmancy;
import bl4ckscor3.mod.snowmancy.entity.goal.SnowmanAttackMeleeGoal;
import bl4ckscor3.mod.snowmancy.entity.goal.SnowmanAttackRangedGoal;
import bl4ckscor3.mod.snowmancy.util.EnumAttackType;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class SnowmanCompanionEntity
extends GolemEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> GOLDEN_NOSE = EntityDataManager.func_187226_a(SnowmanCompanionEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> ATTACK_TYPE = EntityDataManager.func_187226_a(SnowmanCompanionEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(SnowmanCompanionEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> EVERCOLD = EntityDataManager.func_187226_a(SnowmanCompanionEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public SnowmanCompanionEntity(EntityType<SnowmanCompanionEntity> type, World world) {
        super(type, world);
    }

    public SnowmanCompanionEntity(World world, boolean goldenNose, String attackType, float damage, boolean evercold) {
        this(Snowmancy.eTypeSnowman, world);
        this.field_70180_af.func_187227_b(GOLDEN_NOSE, (Object)goldenNose);
        this.field_70180_af.func_187227_b(ATTACK_TYPE, (Object)attackType);
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        this.field_70180_af.func_187227_b(EVERCOLD, (Object)evercold);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GOLDEN_NOSE, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TYPE, (Object)EnumAttackType.HIT.name());
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EVERCOLD, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SnowmanAttackMeleeGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SnowmanAttackRangedGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IMob));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isEvercold() && this.field_70170_p.func_226691_t_(this.func_233580_cy_()).func_242445_k() >= 0.2f) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (player.func_213453_ef() && hand == Hand.MAIN_HAND) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)this.createItem());
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ItemStack createItem() {
        ItemStack stack = new ItemStack((IItemProvider)Snowmancy.FROZEN_SNOWMAN);
        CompoundNBT tag = new CompoundNBT();
        this.func_213281_b(tag);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        EggEntity throwableEntity;
        EnumAttackType type = EnumAttackType.valueOf(this.getAttackType());
        switch (type) {
            case ARROW: {
                throwableEntity = ((ArrowItem)Items.field_151032_g).func_200887_a(this.field_70170_p, new ItemStack((IItemProvider)Items.field_151032_g, 1), (LivingEntity)this);
                break;
            }
            case EGG: {
                throwableEntity = new EggEntity(this.field_70170_p, (LivingEntity)this);
                break;
            }
            case SNOWBALL: {
                throwableEntity = new SnowballEntity(this.field_70170_p, (LivingEntity)this);
                break;
            }
            default: {
                return;
            }
        }
        double d0 = target.func_226278_cu_() + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - throwableEntity.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        throwableEntity.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)throwableEntity);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(GOLDEN_NOSE, (Object)tag.func_74767_n("goldenCarrot"));
        this.field_70180_af.func_187227_b(ATTACK_TYPE, (Object)tag.func_74779_i("attackType"));
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(tag.func_74760_g("damage")));
        this.field_70180_af.func_187227_b(EVERCOLD, (Object)tag.func_74767_n("evercold"));
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74757_a("goldenCarrot", this.isNoseGolden());
        tag.func_74778_a("attackType", this.getAttackType());
        tag.func_74776_a("damage", this.getDamage());
        tag.func_74757_a("evercold", this.isEvercold());
    }

    public boolean isNoseGolden() {
        return (Boolean)this.field_70180_af.func_187225_a(GOLDEN_NOSE);
    }

    public String getAttackType() {
        return (String)this.field_70180_af.func_187225_a(ATTACK_TYPE);
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public boolean isEvercold() {
        return (Boolean)this.field_70180_af.func_187225_a(EVERCOLD);
    }
}

