/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.UpgradeGraveKeyRecipe;
import ovh.corail.tombstone.handler.ConfigurationHandler;

public class Helper {
    public static Random random = new Random();

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static Set<String> loadWhitelist(File whitelistFile) {
        HashSet<String> whitelist = new HashSet<String>();
        if (!whitelistFile.exists()) {
            whitelist.add("minecraft:tallgrass:0");
            whitelist.add("minecraft:tallgrass:1");
            whitelist.add("minecraft:tallgrass:2");
            whitelist.add("minecraft:deadbush:0");
            whitelist.add("minecraft:double_plant:0");
            whitelist.add("minecraft:double_plant:1");
            whitelist.add("minecraft:double_plant:2");
            whitelist.add("minecraft:double_plant:3");
            whitelist.add("minecraft:double_plant:4");
            whitelist.add("minecraft:double_plant:5");
            whitelist.add("minecraft:snow_layer:0");
            Helper.saveAsJson(whitelistFile, whitelist);
        } else {
            Type token = new TypeToken<Set<String>>(){}.getType();
            whitelist = Helper.loadAsJson(whitelistFile, token);
        }
        return whitelist;
    }

    public static boolean saveAsJson(File file, Set<?> list) {
        if (file.exists()) {
            file.delete();
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(new GsonBuilder().setPrettyPrinting().create().toJson(list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Set<?> loadAsJson(File file, Type token) {
        Set list = null;
        try {
            list = (Set)new Gson().fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void sendMessage(String message, EntityPlayer player, boolean translate) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            if (translate) {
                message = Helper.getTranslation(message);
            }
            player.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    public static String getTranslation(String message) {
        return StatCollector.func_74838_a((String)message);
    }

    public static void sendLog(String message) {
        if (Main.logger != null) {
            Main.logger.log(Level.INFO, message);
        } else {
            System.out.println(message);
        }
    }

    public static boolean areItemEqual(ItemStack s1, ItemStack s2) {
        return s1.func_77969_a(s2) && s1.func_77960_j() == s2.func_77960_j() && ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static void render() {
        Helper.render(Main.decorative_grave_simple);
        Helper.render(Main.decorative_grave_normal);
        Helper.render(Main.decorative_grave_cross);
        Helper.render(Main.decorative_tombstone);
        Helper.render(Main.itemAchievement001);
        Helper.render(Main.itemAchievement002);
        Helper.render(Main.itemAchievement003);
        Helper.render(Main.grave_key);
        Helper.render(Main.fake_fog);
        Helper.render(Main.soul);
        Helper.render(Main.scroll_of_recall);
    }

    public static void render(Block block) {
        Helper.render(Item.func_150898_a((Block)block), 0);
    }

    public static void render(Item item) {
        Helper.render(item, 0);
    }

    public static void render(Block block, int meta) {
        Helper.render(Item.func_150898_a((Block)block), meta);
    }

    private static void render(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void register() {
        Helper.register(Main.grave_simple);
        Helper.register(Main.grave_normal);
        Helper.register(Main.grave_cross);
        Helper.register(Main.tombstone);
        Helper.register(Main.decorative_grave_simple);
        Helper.register(Main.decorative_grave_normal);
        Helper.register(Main.decorative_grave_cross);
        Helper.register(Main.decorative_tombstone);
        Helper.register(Main.itemAchievement001);
        Helper.register(Main.itemAchievement002);
        Helper.register(Main.itemAchievement003);
        Helper.register(Main.grave_key);
        Helper.register(Main.fake_fog);
        Helper.register(Main.soul);
        Helper.register(Main.scroll_of_recall);
    }

    public static void register(BlockGrave grave) {
        if (grave.isDecorative()) {
            GameRegistry.registerBlock((Block)grave, ItemBlockGrave.class);
        } else {
            GameRegistry.registerBlock((Block)grave, null, (String)grave.getRegistryName());
        }
    }

    public static void register(Block block) {
        GameRegistry.registerBlock((Block)block);
    }

    public static void register(Item item) {
        GameRegistry.registerItem((Item)item);
    }

    public static boolean isSafeBlock(World world, BlockPos currentPos) {
        IBlockState state = world.func_180495_p(currentPos);
        Block block = state.func_177230_c();
        if (currentPos.func_177956_o() < 1) {
            return false;
        }
        if (world.func_175625_s(currentPos) != null) {
            return false;
        }
        if (world.func_175623_d(currentPos)) {
            return true;
        }
        return Main.whitelist.contains(block.getRegistryName().toString() + ":" + block.func_176201_c(state));
    }

    public static int[] calculXp(double totalXp) {
        return Helper.calculXp((int)Math.floor(totalXp));
    }

    public static int[] calculXp(int totalXp) {
        int nextLevel;
        int level;
        if (totalXp <= 352) {
            level = 0;
            while (totalXp >= 2 * level + 7) {
                totalXp -= 2 * level + 7;
                ++level;
            }
            nextLevel = 2 * level + 7;
        } else if (totalXp <= 1507) {
            totalXp -= 352;
            level = 16;
            while (totalXp >= 5 * level - 38) {
                totalXp -= 5 * level - 38;
                ++level;
            }
            nextLevel = 5 * level - 38;
        } else {
            totalXp -= 1507;
            level = 31;
            while (totalXp >= 9 * level - 158) {
                totalXp -= 9 * level - 158;
                ++level;
            }
            nextLevel = 9 * level - 158;
        }
        int[] result = new int[]{level, totalXp, nextLevel};
        return result;
    }

    public static ItemStack addToInventoryWithLeftover(ItemStack stack, IInventory inventory, boolean simulate) {
        ItemStack in;
        int i;
        int left = stack.field_77994_a;
        int minus = inventory instanceof InventoryPlayer ? 4 : 0;
        int max = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        for (i = 0; i < inventory.func_70302_i_() - minus; ++i) {
            int space;
            int add;
            in = inventory.func_70301_a(i);
            if (in == null || !stack.func_77969_a(in) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)in) || (add = Math.min(space = max - in.field_77994_a, stack.field_77994_a)) <= 0) continue;
            if (!simulate) {
                in.field_77994_a += add;
            }
            if ((left -= add) > 0) continue;
            return null;
        }
        for (i = 0; i < inventory.func_70302_i_() - minus; ++i) {
            in = inventory.func_70301_a(i);
            if (in != null) continue;
            int add = Math.min(max, left);
            if (!simulate) {
                inventory.func_70299_a(i, Helper.copyStack(stack, add));
            }
            if ((left -= add) > 0) continue;
            return null;
        }
        return Helper.copyStack(stack, left);
    }

    private static ItemStack copyStack(ItemStack stack, int size) {
        if (stack == null || size == 0) {
            return null;
        }
        ItemStack tmp = stack.func_77946_l();
        tmp.field_77994_a = Math.min(size, stack.func_77976_d());
        return tmp;
    }

    public static void registerEncodedRecipes() {
        if (ConfigurationHandler.upgradeTombKey) {
            String[] parts = ConfigurationHandler.ingredientToUpgradeKey.split(":");
            ItemStack ingredient = parts.length == 4 ? new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1])), Integer.valueOf(parts[2]).intValue(), Integer.valueOf(parts[3]).intValue()) : (parts.length == 3 ? new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1])), Integer.valueOf(parts[2]).intValue()) : new ItemStack(Items.field_151079_bi, 1));
            ItemStack res = new ItemStack((Item)Main.grave_key);
            res.func_77982_d(new NBTTagCompound());
            res.func_77978_p().func_74757_a("enchant", true);
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
            inputList.add(new ItemStack((Item)Main.grave_key, 1));
            inputList.add(ingredient);
            RecipeSorter.register((String)"tombstone:upgradeKey", UpgradeGraveKeyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new UpgradeGraveKeyRecipe(res, inputList));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Main.decorative_grave_simple, 1), new Object[]{" 0 ", "010", Character.valueOf('0'), "stone", Character.valueOf('1'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Main.decorative_grave_normal, 1), new Object[]{" 0 ", " 0 ", "010", Character.valueOf('0'), "stone", Character.valueOf('1'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Main.decorative_grave_cross, 1), new Object[]{" 0 ", "010", " 0 ", Character.valueOf('0'), "stone", Character.valueOf('1'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Main.decorative_tombstone, 1), new Object[]{" 0 ", "010", "000", Character.valueOf('0'), "stone", Character.valueOf('1'), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE)}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Main.scroll_of_recall, 1, 0), (Object[])new Object[]{Items.field_151121_aF, new ItemStack(Items.field_151100_aR, 1, 15)});
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float f = random.nextFloat() * 0.8f + 0.1f;
        float f1 = random.nextFloat() * 0.8f + 0.1f;
        float f2 = random.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int i = random.nextInt(21) + 10;
            if (i > stack.field_77994_a) {
                i = stack.field_77994_a;
            }
            stack.field_77994_a -= i;
            EntityItem entityitem = new EntityItem(worldIn, x + (double)f, y + (double)f1, z + (double)f2, new ItemStack(stack.func_77973_b(), i, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            float f3 = 0.05f;
            entityitem.field_70159_w = random.nextGaussian() * (double)f3;
            entityitem.field_70181_x = random.nextGaussian() * (double)f3 + (double)0.2f;
            entityitem.field_70179_y = random.nextGaussian() * (double)f3;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }
}

