/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import java.util.Date;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import nightkosh.gravestone.api.GraveStoneAPI;
import ovh.corail.tombstone.block.BlockFacingGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.DeathHandler;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.handler.SpawnProtectionHandler;
import ovh.corail.tombstone.item.ItemGraveKey;
import ovh.corail.tombstone.packet.TombstoneActivatedMessage;
import ovh.corail.tombstone.packet.UpdateServerMessage;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class EventHandler {
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("tombstone")) {
            ConfigurationHandler.refreshConfig();
            if (!ConfigurationHandler.lastFavoriteGrave.equals(ConfigurationHandler.favoriteGrave)) {
                ConfigurationHandler.lastFavoriteGrave = ConfigurationHandler.favoriteGrave;
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerMessage(ConfigurationHandler.favoriteGrave, false));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLogued(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (event.world.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerMessage(ConfigurationHandler.favoriteGrave, true));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!ConfigurationHandler.handlePlayerDeath || !(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory") || player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (event.drops.size() <= 0 || event.drops.size() > 64) {
            return;
        }
        this.buildTombstone(event, player);
        player.func_71064_a((StatBase)AchievementHandler.getAchievement("first_tomb"), 1);
        if ((Loader.isModLoaded((String)"gravestone") || Loader.isModLoaded((String)"GraveStone")) && GraveStoneAPI.graveGenerationAtDeath == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void give(PlayerEvent.Clone event) {
        EntityPlayer player = event.entityPlayer;
        EntityPlayer original = event.original;
        if (!event.wasDeath || player.field_71075_bZ.field_75098_d) {
            return;
        }
        player.field_71067_cb = !ConfigurationHandler.xpLoss ? event.original.field_71067_cb : (int)Math.floor(original.field_71067_cb * (100 - ConfigurationHandler.percentXpLoss) / 100);
        int[] result = Helper.calculXp(player.field_71067_cb);
        player.field_71068_ca = result[0];
        player.field_71106_cc = (float)result[1] / (float)result[2];
        if (!ConfigurationHandler.handlePlayerDeath || !ConfigurationHandler.tombAccess || player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (int i = 0; i < original.field_71071_by.func_70302_i_(); ++i) {
            if (original.field_71071_by.func_70301_a(i) == null) continue;
            ItemStack originalStack = original.field_71071_by.func_70301_a(i).func_77946_l();
            ItemStack playerStack = player.field_71071_by.func_70301_a(i);
            if (originalStack == null || !(originalStack.func_77973_b() instanceof ItemGraveKey) || playerStack != null && playerStack.func_77973_b() instanceof ItemGraveKey) continue;
            player.field_71071_by.func_70299_a(i, originalStack);
            original.field_71071_by.func_70299_a(i, null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            event.setCanceled(true);
        }
    }

    public void buildTombstone(LivingDropsEvent event, EntityPlayer player) {
        ItemStack stack;
        Entity killer;
        World world = player.field_70170_p;
        BlockPos currentPos = player.func_180425_c();
        while (!Helper.isSafeBlock(world, currentPos)) {
            currentPos = currentPos.func_177984_a();
        }
        EnumFacing facing = event.entityLiving.func_174811_aO().func_176734_d();
        Block graveType = DeathHandler.getInstance().getFavoriteGraveBlock(player.func_110124_au());
        IBlockState state = graveType.func_176223_P().func_177226_a((IProperty)BlockFacingGrave.FACING, (Comparable)facing);
        world.func_175656_a(currentPos, state);
        TileEntityTombstone tile = (TileEntityTombstone)world.func_175625_s(currentPos);
        boolean needAccess = ConfigurationHandler.tombAccess;
        if (needAccess && ConfigurationHandler.pvpMode && event.source != null && (killer = event.source.func_76364_f()) != null && killer instanceof EntityPlayer) {
            needAccess = false;
        }
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        tile.setOwner(player, new Date().getTime(), needAccess);
        for (EntityItem drop : event.drops) {
            stack = drop.func_92059_d();
            if (stack == null) continue;
            if (stack.func_77973_b() != Main.grave_key) {
                ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                continue;
            }
            Helper.addToInventoryWithLeftover(stack, (IInventory)player.field_71071_by, false);
        }
        event.drops.clear();
        double range = ConfigurationHandler.snifferRange;
        List itemList = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)currentPos.func_177958_n() - range, (double)currentPos.func_177956_o() - range, (double)currentPos.func_177952_p() - range, (double)currentPos.func_177958_n() + range, (double)currentPos.func_177956_o() + range, (double)currentPos.func_177952_p() + range));
        for (EntityItem entityItem : itemList) {
            stack = entityItem.func_92059_d();
            if (stack == null) continue;
            ItemStack leftOver = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (leftOver == null) {
                entityItem.func_70106_y();
                continue;
            }
            entityItem.func_92058_a(leftOver);
        }
        if (ConfigurationHandler.tombAccess) {
            stack = new ItemStack((Item)Main.grave_key, 1, 0);
            ItemGraveKey.setTombPos(stack, currentPos, world.field_73011_w.func_177502_q());
            Helper.addToInventoryWithLeftover(stack, (IInventory)player.field_71071_by, false);
        }
        world.markAndNotifyBlock(currentPos, world.func_175726_f(currentPos), state, state, 2);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        Item ingredient;
        Item input = event.left == null ? null : event.left.func_77973_b();
        Item item = ingredient = event.right == null ? null : event.right.func_77973_b();
        if (input instanceof ItemBlockGrave && ingredient == Items.field_151055_y) {
            ItemStack output = event.left.func_77946_l();
            if (ItemBlockGrave.setEngravedName(output, event.name)) {
                event.cost = 2;
                event.output = output;
            } else {
                event.cost = 0;
                event.output = null;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilRepair(AnvilRepairEvent event) {
        Item input = event.output == null ? null : event.output.func_77973_b();
        Item ingredient = event.left == null ? null : event.left.func_77973_b();
        ItemStack output = event.right;
        if (input instanceof ItemBlockGrave && ingredient == Items.field_151055_y && ItemBlockGrave.isEngraved(output)) {
            event.entityPlayer.func_71064_a((StatBase)AchievementHandler.getAchievement("engrave_decorative_grave"), 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void uncancelGraveRightClick(PlayerInteractEvent event) {
        Block block;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.isCanceled() && (block = event.world.func_180495_p(event.pos).func_177230_c()) instanceof BlockGrave && !((BlockGrave)block).isDecorative()) {
            SpawnProtectionHandler handler;
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.useBlock = Event.Result.DEFAULT;
                event.useItem = Event.Result.DEFAULT;
            }
            if (event.world.field_72995_K && (handler = SpawnProtectionHandler.getInstance()).isBlockProtected(event.world.field_73011_w.func_177502_q(), event.pos)) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new TombstoneActivatedMessage(event.pos));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void uncancelGraveBuild(BlockEvent.PlaceEvent event) {
        Block block;
        if (event.isCanceled() && (block = event.world.func_180495_p(event.pos).func_177230_c()) instanceof BlockGrave && !((BlockGrave)block).isDecorative()) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDropsStart(LivingDropsEvent event) {
        if (!ConfigurationHandler.handlePlayerDeath) {
            return;
        }
        if ((Loader.isModLoaded((String)"gravestone") || Loader.isModLoaded((String)"GraveStone")) && GraveStoneAPI.graveGenerationAtDeath == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLivingDropsEnd(LivingDropsEvent event) {
        if (!ConfigurationHandler.handlePlayerDeath) {
            return;
        }
        if ((Loader.isModLoaded((String)"gravestone") || Loader.isModLoaded((String)"GraveStone")) && GraveStoneAPI.graveGenerationAtDeath == null) {
            event.setCanceled(false);
        }
    }
}

